/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.websphere.v50;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiException;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.websphere.pmi.client.PmiClient;
import com.liveperf.common.F.C;
import com.liveperf.rms.EntityId;
import com.liveperf.rms.P;
import com.liveperf.rms.agents.Agent;
import com.liveperf.rms.agents.AgentCustomConfiguration;
import com.liveperf.rms.agents.AgentId;
import com.liveperf.rms.agents.D;
import com.liveperf.rms.agents.impl.AbstractAgent;
import com.liveperf.rms.agents.websphere.v50.A;
import com.liveperf.rms.agents.websphere.v50.B;
import com.liveperf.rms.agents.websphere.v50.Configuration;
import com.liveperf.rms.agents.websphere.v50.F;
import com.liveperf.rms.agents.websphere.v50.G;
import com.liveperf.rms.agents.websphere.v50.I;
import com.liveperf.rms.agents.websphere.v50.J;
import com.liveperf.rms.agents.websphere.v50.proxy.PerfDescriptor;
import com.liveperf.rms.agents.websphere.v50.proxy.PmiClientProxy;
import com.liveperf.rms.exception.InvalidConfiguration;
import com.liveperf.rms.exception.RMSException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WebSphereAgent
extends AbstractAgent
implements PmiConstants {
    protected Configuration wsConfig;
    protected PmiClientProxy client;
    protected com.liveperf.rms.agents.websphere.B clientProcess;
    protected Map entityData;
    protected Map moduleData;
    protected Map enabledPerfDescriptors;
    protected I versionBehaviour;

    public WebSphereAgent(AgentId agentId, Agent._A _A2) throws Throwable {
        super(agentId, _A2);
        this.replaceContext(new _A());
        this.entityData = new HashMap();
        this.moduleData = new HashMap();
        this.enabledPerfDescriptors = new HashMap();
        this.fRootEntity = new A(this.\u0157());
        this.versionBehaviour = new F();
    }

    private void \u0159() throws RemoteException, PmiException {
        int n;
        PmiModuleConfig pmiModuleConfig;
        PerfDescriptor[] perfDescriptorArray = this.\u0158();
        if (perfDescriptorArray == null || perfDescriptorArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < perfDescriptorArray.length) {
            block10: {
                try {
                    PerfDescriptor perfDescriptor = perfDescriptorArray[n2];
                    String string = perfDescriptor.getNodeName();
                    pmiModuleConfig = this.w(string);
                    if (pmiModuleConfig == null || ((PmiModuleConfig)pmiModuleConfig).length <= 0) break block10;
                    n = 0;
                    while (n < ((PmiModuleConfig)pmiModuleConfig).length) {
                        String string2 = pmiModuleConfig[n].getServerName();
                        try {
                            PerfLevelSpec[] perfLevelSpecArray = this.client.getInstrumentationLevel(string, string2);
                            if (perfLevelSpecArray != null) {
                                int n3 = 0;
                                while (n3 < perfLevelSpecArray.length) {
                                    PerfLevelSpec perfLevelSpec = perfLevelSpecArray[n3];
                                    String[] stringArray = perfLevelSpec.getPath();
                                    String[] stringArray2 = new String[stringArray.length + 2];
                                    stringArray2[0] = "root";
                                    stringArray2[1] = string;
                                    stringArray2[2] = string2;
                                    System.arraycopy(stringArray, 1, stringArray2, 3, stringArray.length - 1);
                                    EntityId entityId = new EntityId(stringArray2);
                                    this.entityData.put(entityId, new J(perfLevelSpec, perfLevelSpec.getLevel(), this.\u0157().A(perfLevelSpec.getLevel())));
                                    ++n3;
                                }
                            }
                        }
                        catch (RemoteException remoteException) {
                            this.fContext.A((Throwable)remoteException);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    this.fContext.A((Throwable)exception);
                }
            }
            ++n2;
        }
        PmiModuleConfig[] pmiModuleConfigArray = this.client.getConfigs();
        n = 0;
        while (n < pmiModuleConfigArray.length) {
            pmiModuleConfig = pmiModuleConfigArray[n];
            this.moduleData.put(pmiModuleConfig.getShortName(), new B(pmiModuleConfig));
            ++n;
        }
    }

    protected void connect() throws Throwable {
        String string;
        this.wsConfig = (Configuration)this.fConfiguration.getCustom();
        Properties properties = new Properties();
        String string2 = this.wsConfig.getString("websphereagent.was_host");
        if (C.C((String)string2)) {
            string2 = this.fConfiguration.getMonitoredHost();
        }
        properties.setProperty("host", string2);
        properties.setProperty("port", String.valueOf(this.wsConfig.getInt("config.port")));
        String string3 = (String)this.wsConfig.getObject("config.username");
        if (string3 != null) {
            properties.setProperty("username", string3);
        }
        if ((string = (String)this.wsConfig.getObject("config.password")) != null) {
            properties.setProperty("password", this.wsConfig.getString("config.password"));
        }
        properties.setProperty("type", this.wsConfig.getString("websphereagent.connector_type"));
        properties.setProperty("securityEnabled", String.valueOf(this.wsConfig.getBoolean("websphereagent.security_enabled")));
        String string4 = this.wsConfig.getString("websphereagent.was_home");
        properties.setProperty("javax.net.ssl.trustStore", String.valueOf(string4) + this.wsConfig.getString("websphereagent.trust_store"));
        properties.setProperty("javax.net.ssl.keyStore", String.valueOf(string4) + this.wsConfig.getString("websphereagent.key_store"));
        properties.setProperty("javax.net.ssl.trustStorePassword", this.wsConfig.getString("websphereagent.trust_store_password"));
        properties.setProperty("javax.net.ssl.keyStorePassword", this.wsConfig.getString("websphereagent.key_store_password"));
        properties.setProperty("com.ibm.SOAP.ConfigURL", "file:/" + string4 + "/properties/soap.client.props");
        try {
            if (this.clientProcess != null) {
                this.clientProcess.A();
            }
            this.clientProcess = new com.liveperf.rms.agents.websphere.B();
            this.client = this.clientProcess.A(this.fConfiguration.getMonitoredHost(), this.fConfiguration.getDeploymentHost(), this.wsConfig.getInt("websphereagent.proxy_rmi_port"), this.wsConfig, properties, this.versionBehaviour.A());
        }
        catch (RMSException rMSException) {
            throw rMSException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected void configCustomChanged() throws InvalidConfiguration, Throwable {
        this.connect();
        ((A)this.fRootEntity).\u013d();
    }

    public synchronized void deactivate() throws Throwable {
        super.deactivate();
        if (this.client != null) {
            try {
                this.client.end();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client = null;
        }
        if (this.clientProcess != null) {
            this.clientProcess.A();
            this.clientProcess = null;
        }
    }

    protected void configMonitoringLevelChanged() throws Throwable {
        ((A)this.fRootEntity).C(this.fConfiguration.getMonitoringLevel());
    }

    protected void configValidateCustom(AgentCustomConfiguration agentCustomConfiguration) throws InvalidConfiguration {
        if (agentCustomConfiguration == null) {
            InvalidConfiguration invalidConfiguration = new InvalidConfiguration("Custom configuration missing");
            invalidConfiguration.setIsInternalAppError();
            throw invalidConfiguration;
        }
    }

    protected void prepareBuffer(D d) throws Throwable {
        CpdCollection[] cpdCollectionArray = this.getCpdCollection();
        if (cpdCollectionArray == null) {
            return;
        }
        ((A)this.fRootEntity).A(cpdCollectionArray);
        super.prepareBuffer(d);
    }

    protected CpdCollection[] getCpdCollection() throws RemoteException, PmiException {
        return this.client.gets(this.enabledPerfDescriptors.values().toArray(new PerfDescriptor[this.enabledPerfDescriptors.size()]), false);
    }

    private G \u0157() {
        return (G)this.fContext;
    }

    private PerfDescriptor[] \u0158() {
        return ((A)this.fRootEntity).\u013e();
    }

    private PerfDescriptor[] w(String string) {
        return ((A)this.fRootEntity).i(string);
    }

    private final class _A
    extends AbstractAgent._A
    implements G {
        _A() {
            super((AbstractAgent)WebSphereAgent.this);
        }

        public PmiClientProxy K() {
            return WebSphereAgent.this.client;
        }

        public String B(String string, String string2) {
            return PmiClient.getNLSValue((String)string, (String)string2);
        }

        public J A(EntityId entityId) {
            return (J)WebSphereAgent.this.entityData.get(entityId);
        }

        public B A(String string) {
            return (B)WebSphereAgent.this.moduleData.get(string);
        }

        public int A(P p) {
            int n = p.getKey();
            switch (n) {
                case -1: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 7;
                }
                case 3: {
                    return 15;
                }
            }
            return -1;
        }

        public P A(int n) {
            switch (n) {
                case 0: {
                    return P.b;
                }
                case 1: {
                    return P.a;
                }
                case 3: {
                    return P.Z;
                }
                case 7: {
                    return P.Y;
                }
                case 15: {
                    return P._;
                }
            }
            return null;
        }

        public void B(EntityId entityId, PerfDescriptor perfDescriptor) {
            WebSphereAgent.this.enabledPerfDescriptors.put(entityId, perfDescriptor);
        }

        public void A(EntityId entityId, PerfDescriptor perfDescriptor) {
            WebSphereAgent.this.enabledPerfDescriptors.remove(entityId);
        }

        public void J() throws RemoteException, PmiException {
            WebSphereAgent.this.\u0159();
        }

        public PerfDescriptor[] I() throws RemoteException, PmiException {
            return WebSphereAgent.this.\u0158();
        }

        public PerfDescriptor[] B(String string) throws RemoteException, PmiException {
            return WebSphereAgent.this.w(string);
        }

        public void L() throws InvalidConfiguration, Throwable {
            WebSphereAgent.this.connect();
        }

        public I M() {
            return WebSphereAgent.this.versionBehaviour;
        }
    }
}

