/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.CombinationDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.general.SubSeriesDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;

public class CombinedDataset
extends AbstractIntervalXYDataset
implements XYDataset,
OHLCDataset,
IntervalXYDataset,
CombinationDataset {
    private List datasetInfo = new ArrayList();

    public CombinedDataset() {
    }

    public CombinedDataset(SeriesDataset[] seriesDatasetArray) {
        this.add(seriesDatasetArray);
    }

    public void add(SeriesDataset seriesDataset) {
        this.fastAdd(seriesDataset);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset[] seriesDatasetArray) {
        int n = 0;
        while (n < seriesDatasetArray.length) {
            this.fastAdd(seriesDatasetArray[n]);
            ++n;
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset seriesDataset, int n) {
        this.add(new SubSeriesDataset(seriesDataset, n));
    }

    private void fastAdd(SeriesDataset seriesDataset) {
        int n = 0;
        while (n < seriesDataset.getSeriesCount()) {
            this.datasetInfo.add(new DatasetInfo(seriesDataset, n));
            ++n;
        }
    }

    public int getSeriesCount() {
        return this.datasetInfo.size();
    }

    public String getSeriesName(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return datasetInfo.data.getSeriesName(datasetInfo.series);
    }

    public Number getX(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getX(datasetInfo.series, n2);
    }

    public Number getY(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getY(datasetInfo.series, n2);
    }

    public int getItemCount(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getItemCount(datasetInfo.series);
    }

    public Number getHigh(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((OHLCDataset)datasetInfo.data).getHigh(datasetInfo.series, n2);
    }

    public double getHighValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getHigh(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getLow(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((OHLCDataset)datasetInfo.data).getLow(datasetInfo.series, n2);
    }

    public double getLowValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getLow(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getOpen(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((OHLCDataset)datasetInfo.data).getOpen(datasetInfo.series, n2);
    }

    public double getOpenValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getOpen(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getClose(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((OHLCDataset)datasetInfo.data).getClose(datasetInfo.series, n2);
    }

    public double getCloseValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getClose(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getVolume(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((OHLCDataset)datasetInfo.data).getVolume(datasetInfo.series, n2);
    }

    public double getVolumeValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getVolume(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getStartX(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartX(datasetInfo.series, n2);
        }
        return this.getX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndX(datasetInfo.series, n2);
        }
        return this.getX(n, n2);
    }

    public Number getStartY(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartY(datasetInfo.series, n2);
        }
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndY(datasetInfo.series, n2);
        }
        return this.getY(n, n2);
    }

    public SeriesDataset getParent() {
        SeriesDataset seriesDataset = null;
        int n = 0;
        while (n < this.datasetInfo.size()) {
            SeriesDataset seriesDataset2 = this.getDatasetInfo(n).data;
            if (seriesDataset2 instanceof CombinationDataset) {
                SeriesDataset seriesDataset3 = ((CombinationDataset)((Object)seriesDataset2)).getParent();
                if (seriesDataset == null) {
                    seriesDataset = seriesDataset3;
                } else if (seriesDataset != seriesDataset3) {
                    return null;
                }
            } else {
                return null;
            }
            ++n;
        }
        return seriesDataset;
    }

    public int[] getMap() {
        int[] nArray = null;
        int n = 0;
        while (n < this.datasetInfo.size()) {
            int[] nArray2;
            SeriesDataset seriesDataset = this.getDatasetInfo(n).data;
            if (seriesDataset instanceof CombinationDataset) {
                nArray2 = ((CombinationDataset)((Object)seriesDataset)).getMap();
                if (nArray2 == null) {
                    return null;
                }
            } else {
                return null;
            }
            nArray = this.joinMap(nArray, nArray2);
            ++n;
        }
        return nArray;
    }

    public int getChildPosition(Dataset dataset) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datasetInfo.size()) {
            SeriesDataset seriesDataset = this.getDatasetInfo(n2).data;
            if (seriesDataset instanceof CombinedDataset) {
                int n3 = ((CombinedDataset)seriesDataset).getChildPosition(dataset);
                if (n3 >= 0) {
                    return n + n3;
                }
                ++n;
            } else {
                if (dataset == seriesDataset) {
                    return n;
                }
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    private DatasetInfo getDatasetInfo(int n) {
        return (DatasetInfo)this.datasetInfo.get(n);
    }

    private int[] joinMap(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private class DatasetInfo {
        private SeriesDataset data;
        private int series;

        DatasetInfo(SeriesDataset seriesDataset, int n) {
            this.data = seriesDataset;
            this.series = n;
        }
    }
}

