/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.contour;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.Range;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.xy.AbstractXYZDataset;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected String seriesName = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(String string, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        this.seriesName = string;
        this.initialize(objectArray, objectArray2, objectArray3);
    }

    public void initialize(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        this.xValues = new Double[objectArray.length];
        this.yValues = new Double[objectArray2.length];
        this.zValues = new Double[objectArray3.length];
        Vector<Integer> vector = new Vector<Integer>();
        double d = 1.123452E31;
        int n = 0;
        while (n < this.xValues.length) {
            if (objectArray[n] != null) {
                Number number;
                if (objectArray[n] instanceof Number) {
                    number = (Number)objectArray[n];
                } else if (objectArray[n] instanceof Date) {
                    this.dateAxis[0] = true;
                    Date date = (Date)objectArray[n];
                    number = new Long(date.getTime());
                } else {
                    number = new Integer(0);
                }
                this.xValues[n] = new Double(number.doubleValue());
                if (d != this.xValues[n].doubleValue()) {
                    vector.add(new Integer(n));
                    d = this.xValues[n].doubleValue();
                }
            }
            ++n;
        }
        Object[] objectArray4 = vector.toArray();
        this.xIndex = new int[objectArray4.length];
        int n2 = 0;
        while (n2 < objectArray4.length) {
            this.xIndex[n2] = (Integer)objectArray4[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.yValues.length) {
            this.yValues[n2] = (Double)objectArray2[n2];
            if (objectArray3[n2] != null) {
                this.zValues[n2] = (Double)objectArray3[n2];
            }
            ++n2;
        }
    }

    public static Object[][] formObjectArray(double[][] dArray) {
        Object[][] objectArray = new Double[dArray.length][dArray[0].length];
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 0;
            while (n2 < objectArray[n].length) {
                objectArray[n][n2] = new Double(dArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        return objectArray;
    }

    public static Object[] formObjectArray(double[] dArray) {
        Object[] objectArray = new Double[dArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new Double(dArray[n]);
            ++n;
        }
        return objectArray;
    }

    public int getItemCount(int n) {
        if (n > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues.length;
    }

    public double getMaxZValue() {
        double d = -1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d = Math.max(d, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d;
    }

    public double getMinZValue() {
        double d = 1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d = Math.min(d, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d;
    }

    public Range getZValueRange(Range range, Range range2) {
        double d = range.getLowerBound();
        double d2 = range2.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = range2.getUpperBound();
        double d5 = 1.0E20;
        double d6 = -1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.xValues[n].doubleValue() >= d && this.xValues[n].doubleValue() <= d3 && this.yValues[n].doubleValue() >= d2 && this.yValues[n].doubleValue() <= d4 && this.zValues[n] != null) {
                d5 = Math.min(d5, this.zValues[n].doubleValue());
                d6 = Math.max(d6, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return new Range(d5, d6);
    }

    public double getMinZValue(double d, double d2, double d3, double d4) {
        double d5 = 1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d5 = Math.min(d5, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d5;
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        if (n > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.seriesName;
    }

    public int[] getXIndices() {
        return this.xIndex;
    }

    public Number[] getXValues() {
        return this.xValues;
    }

    public Number getX(int n, int n2) {
        if (n > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.xValues[n2];
    }

    public Number getXValue(int n) {
        return this.xValues[n];
    }

    public Number[] getYValues() {
        return this.yValues;
    }

    public Number getY(int n, int n2) {
        if (n > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.yValues[n2];
    }

    public Number[] getZValues() {
        return this.zValues;
    }

    public Number getZ(int n, int n2) {
        if (n > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues[n2];
    }

    public int[] indexX() {
        int[] nArray = new int[this.xValues.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.indexX(n);
            ++n;
        }
        return nArray;
    }

    public int indexX(int n) {
        int n2 = Arrays.binarySearch(this.xIndex, n);
        if (n2 >= 0) {
            return n2;
        }
        return -1 * n2 - 2;
    }

    public int indexY(int n) {
        return n / this.xValues.length;
    }

    public int indexZ(int n, int n2) {
        return this.xValues.length * n2 + n;
    }

    public boolean isDateAxis(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        return this.dateAxis[n];
    }

    public void setSeriesNames(String[] stringArray) {
        if (stringArray.length > 1) {
            throw new IllegalArgumentException("Contours only support one series");
        }
        this.seriesName = stringArray[0];
        this.fireDatasetChanged();
    }
}

