/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.KeyedObject;
import org.jfree.util.PublicCloneable;

public class KeyedObjects
implements Cloneable,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public int getItemCount() {
        return this.data.size();
    }

    public Object getObject(int n) {
        KeyedObject keyedObject;
        Object object = null;
        if (n >= 0 && n < this.data.size() && (keyedObject = (KeyedObject)this.data.get(n)) != null) {
            object = keyedObject.getObject();
        }
        return object;
    }

    public Comparable getKey(int n) {
        KeyedObject keyedObject;
        Comparable comparable = null;
        if (n >= 0 && n < this.data.size() && (keyedObject = (KeyedObject)this.data.get(n)) != null) {
            comparable = keyedObject.getKey();
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        int n2 = 0;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            KeyedObject keyedObject = (KeyedObject)iterator.next();
            if (keyedObject.getKey().equals(comparable)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            KeyedObject keyedObject = (KeyedObject)iterator.next();
            arrayList.add(keyedObject.getKey());
        }
        return arrayList;
    }

    public Object getObject(Comparable comparable) {
        return this.getObject(this.getIndex(comparable));
    }

    public void addObject(Comparable comparable, Object object) {
        this.setObject(comparable, object);
    }

    public void setObject(Comparable comparable, Object object) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            KeyedObject keyedObject = (KeyedObject)this.data.get(n);
            keyedObject.setObject(object);
        } else {
            KeyedObject keyedObject = new KeyedObject(comparable, object);
            this.data.add(keyedObject);
        }
    }

    public void removeValue(int n) {
        this.data.remove(n);
    }

    public void removeValue(Comparable comparable) {
        this.removeValue(this.getIndex(comparable));
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects keyedObjects = (KeyedObjects)super.clone();
        keyedObjects.data = new ArrayList();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            KeyedObject keyedObject = (KeyedObject)iterator.next();
            keyedObjects.data.add(keyedObject.clone());
        }
        return keyedObjects;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects)) {
            return false;
        }
        KeyedObjects keyedObjects = (KeyedObjects)object;
        int n = this.getItemCount();
        if (n != keyedObjects.getItemCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(n2);
            if (!comparable2.equals(comparable = keyedObjects.getKey(n2))) {
                return false;
            }
            Object object2 = this.getObject(n2);
            Object object3 = keyedObjects.getObject(n2);
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

