/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;
import org.jfree.util.ObjectUtilities;

public class DefaultKeyedValues2D
implements KeyedValues2D,
Cloneable,
Serializable {
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();
    private boolean sortRowKeys;

    public DefaultKeyedValues2D() {
        this(false);
    }

    public DefaultKeyedValues2D(boolean bl) {
        this.sortRowKeys = bl;
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int n, int n2) {
        Comparable comparable;
        int n3;
        Number number = null;
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        if (defaultKeyedValues != null && (n3 = defaultKeyedValues.getIndex(comparable = (Comparable)this.columnKeys.get(n2))) >= 0) {
            number = defaultKeyedValues.getValue(n3);
        }
        return number;
    }

    public Comparable getRowKey(int n) {
        return (Comparable)this.rowKeys.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, comparable);
        }
        return this.rowKeys.indexOf(comparable);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.columnKeys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.columnKeys.indexOf(comparable);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (comparable2 == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        Number number = null;
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
            number = defaultKeyedValues.getValue(comparable2);
        }
        return number;
    }

    public void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void setValue(Number number, Comparable comparable, Comparable comparable2) {
        DefaultKeyedValues defaultKeyedValues;
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        } else {
            defaultKeyedValues = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                n = -n - 1;
                this.rowKeys.add(n, comparable);
                this.rows.add(n, defaultKeyedValues);
            } else {
                this.rowKeys.add(comparable);
                this.rows.add(defaultKeyedValues);
            }
        }
        defaultKeyedValues.setValue(comparable2, number);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeValue(Comparable comparable, Comparable comparable2) {
        this.setValue(null, comparable, comparable2);
        boolean bl = true;
        int n = this.getRowIndex(comparable);
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        int n2 = 0;
        int n3 = defaultKeyedValues.getItemCount();
        while (n2 < n3) {
            if (defaultKeyedValues.getValue(n2) != null) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.rowKeys.remove(n);
            this.rows.remove(n);
        }
        bl = true;
        n2 = this.getColumnIndex(comparable2);
        n3 = 0;
        int n4 = this.rows.size();
        while (n3 < n4) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n3);
            if (defaultKeyedValues.getValue(n2) != null) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            n3 = 0;
            n4 = this.rows.size();
            while (n3 < n4) {
                defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n3);
                defaultKeyedValues.removeValue(n2);
                ++n3;
            }
            this.columnKeys.remove(n2);
        }
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable comparable) {
        this.removeRow(this.getRowIndex(comparable));
    }

    public void removeColumn(int n) {
        Comparable comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)iterator.next();
            defaultKeyedValues.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D keyedValues2D = (KeyedValues2D)object;
        if (!this.getRowKeys().equals(keyedValues2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedValues2D.getColumnKeys())) {
            return false;
        }
        int n = this.getRowCount();
        if (n != keyedValues2D.getRowCount()) {
            return false;
        }
        int n2 = this.getColumnCount();
        if (n2 != keyedValues2D.getColumnCount()) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Number number = this.getValue(n3, n4);
                Number number2 = keyedValues2D.getValue(n3, n4);
                if (number == null ? number2 != null : !number.equals(number2)) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public int hashCode() {
        int n = this.rowKeys.hashCode();
        n = 29 * n + this.columnKeys.hashCode();
        n = 29 * n + this.rows.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues2D defaultKeyedValues2D = (DefaultKeyedValues2D)super.clone();
        defaultKeyedValues2D.columnKeys = new ArrayList(this.columnKeys);
        defaultKeyedValues2D.rowKeys = new ArrayList(this.rowKeys);
        defaultKeyedValues2D.rows = (List)ObjectUtilities.deepClone((Collection)this.rows);
        return defaultKeyedValues2D;
    }
}

