/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesURLGenerator
implements XYURLGenerator,
Serializable {
    private DateFormat dateFormat = DateFormat.getInstance();
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public TimeSeriesURLGenerator() {
    }

    public TimeSeriesURLGenerator(DateFormat dateFormat, String string, String string2, String string3) {
        this.dateFormat = dateFormat;
        this.prefix = string;
        this.seriesParameterName = string2;
        this.itemParameterName = string3;
    }

    public String generateURL(XYDataset xYDataset, int n, int n2) {
        String string = this.prefix;
        boolean bl = string.indexOf("?") == -1;
        String string2 = xYDataset.getSeriesName(n);
        if (string2 != null) {
            string = String.valueOf(string) + (bl ? "?" : "&amp;");
            string = String.valueOf(string) + this.seriesParameterName + "=" + string2;
            bl = false;
        }
        long l = xYDataset.getX(n, n2).longValue();
        String string3 = this.dateFormat.format(new Date(l));
        string = String.valueOf(string) + (bl ? "?" : "&amp;");
        string = String.valueOf(string) + this.itemParameterName + "=" + string3;
        return string;
    }
}

