/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.ui.RectangleAnchor;
import org.jfree.util.ShapeUtilities;

public class LegendGraphic
extends AbstractBlock
implements Block {
    private boolean shapeVisible;
    private Shape shape;
    private RectangleAnchor shapeAnchor;
    private RectangleAnchor shapeLocation;
    private boolean shapeFilled;
    private Paint fillPaint;
    private boolean shapeOutlineVisible;
    private Paint outlinePaint;
    private Stroke outlineStroke;
    private boolean lineVisible;
    private Shape line;
    private Stroke lineStroke;
    private Paint linePaint;

    public LegendGraphic(Shape shape, Paint paint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        this.shapeVisible = true;
        this.shape = shape;
        this.shapeAnchor = RectangleAnchor.CENTER;
        this.shapeLocation = RectangleAnchor.CENTER;
        this.shapeFilled = true;
        this.fillPaint = paint;
    }

    public void setShapeAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.shapeAnchor = rectangleAnchor;
    }

    public void setShapeLocation(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.shapeLocation = rectangleAnchor;
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public void setShapeVisible(boolean bl) {
        this.shapeVisible = bl;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public void setShapeFilled(boolean bl) {
        this.shapeFilled = bl;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public void setShapeOutlineVisible(boolean bl) {
        this.shapeOutlineVisible = bl;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean bl) {
        this.lineVisible = bl;
    }

    public Shape getLine() {
        return this.line;
    }

    public void setLine(Shape shape) {
        this.line = shape;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object;
        if (this.lineVisible) {
            object = ShapeUtilities.createTranslatedShape((Shape)this.getLine(), (double)rectangle2D.getCenterX(), (double)rectangle2D.getCenterY());
            graphics2D.setPaint(this.linePaint);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.draw((Shape)object);
        }
        if (this.shapeVisible) {
            object = RectangleAnchor.coordinates((Rectangle2D)rectangle2D, (RectangleAnchor)this.shapeLocation);
            Shape shape = ShapeUtilities.createTranslatedShape((Shape)this.shape, (RectangleAnchor)this.shapeAnchor, (double)((Point2D)object).getX(), (double)((Point2D)object).getY());
            if (this.shapeFilled) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(shape);
            }
            if (this.shapeOutlineVisible) {
                graphics2D.setPaint(this.outlinePaint);
                graphics2D.setStroke(this.outlineStroke);
                graphics2D.draw(shape);
            }
        }
    }
}

