/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYLineAndShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean defaultLinesVisible;
    private Boolean shapesVisible;
    private BooleanList seriesShapesVisible;
    private boolean defaultShapesVisible;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean defaultShapesFilled;
    private boolean drawOutlines;
    private boolean useFillPaint;
    private boolean useOutlinePaint;
    private boolean drawSeriesLineAsPath;

    public XYLineAndShapeRenderer() {
        this(true, true);
    }

    public XYLineAndShapeRenderer(boolean bl, boolean bl2) {
        this.defaultLinesVisible = bl;
        this.shapesVisible = null;
        this.seriesShapesVisible = new BooleanList();
        this.defaultShapesVisible = bl2;
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = true;
        this.drawOutlines = true;
        this.useFillPaint = false;
        this.useOutlinePaint = false;
        this.drawSeriesLineAsPath = false;
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
        this.drawSeriesLineAsPath = bl;
    }

    public int getPassCount() {
        return 2;
    }

    public boolean getItemLineVisible(int n, int n2) {
        Boolean bl = this.linesVisible;
        if (bl == null) {
            bl = this.getSeriesLinesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultLinesVisible;
    }

    public Boolean getLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(Boolean bl) {
        this.linesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setLinesVisible(boolean bl) {
        this.setLinesVisible(BooleanUtilities.valueOf((boolean)bl));
    }

    public Boolean getSeriesLinesVisible(int n) {
        return this.seriesLinesVisible.getBoolean(n);
    }

    public void setSeriesLinesVisible(int n, Boolean bl) {
        this.seriesLinesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLinesVisible(int n, boolean bl) {
        this.setSeriesLinesVisible(n, BooleanUtilities.valueOf((boolean)bl));
    }

    public boolean getDefaultLinesVisible() {
        return this.defaultLinesVisible;
    }

    public void setDefaultLinesVisible(boolean bl) {
        this.defaultLinesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeVisible(int n, int n2) {
        Boolean bl = this.shapesVisible;
        if (bl == null) {
            bl = this.getSeriesShapesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesVisible;
    }

    public Boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(Boolean bl) {
        this.shapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setShapesVisible(boolean bl) {
        this.setShapesVisible(BooleanUtilities.valueOf((boolean)bl));
    }

    public Boolean getSeriesShapesVisible(int n) {
        return this.seriesShapesVisible.getBoolean(n);
    }

    public void setSeriesShapesVisible(int n, boolean bl) {
        this.setSeriesShapesVisible(n, BooleanUtilities.valueOf((boolean)bl));
    }

    public void setSeriesShapesVisible(int n, Boolean bl) {
        this.seriesShapesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesVisible() {
        return this.defaultShapesVisible;
    }

    public void setDefaultShapesVisible(boolean bl) {
        this.defaultShapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeFilled(int n, int n2) {
        Boolean bl = this.shapesFilled;
        if (bl == null) {
            bl = this.getSeriesShapesFilled(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtilities.valueOf((boolean)bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Boolean getSeriesShapesFilled(int n) {
        return this.seriesShapesFilled.getBoolean(n);
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.setSeriesShapesFilled(n, BooleanUtilities.valueOf((boolean)bl));
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(boolean bl) {
        this.defaultShapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        return state;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (this.isLinePass(n3)) {
            if (n2 == 0 && this.drawSeriesLineAsPath) {
                State state = (State)xYItemRendererState;
                state.seriesPath.reset();
                state.lastPointGood = false;
            }
            if (this.getItemLineVisible(n, n2)) {
                if (this.drawSeriesLineAsPath) {
                    this.drawPrimaryLineAsPath(xYItemRendererState, graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, valueAxis2, rectangle2D);
                } else {
                    this.drawPrimaryLine(xYItemRendererState, graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, valueAxis2, rectangle2D);
                }
            }
        } else if (this.isItemPass(n3)) {
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, rectangle2D, valueAxis2, crosshairState, entityCollection);
        }
    }

    protected boolean isLinePass(int n) {
        return n == 0;
    }

    protected boolean isItemPass(int n) {
        return n == 1;
    }

    protected void drawPrimaryLine(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        if (n3 == 0) {
            return;
        }
        double d = xYDataset.getXValue(n2, n3);
        double d2 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return;
        }
        double d3 = xYDataset.getXValue(n2, n3 - 1);
        double d4 = xYDataset.getYValue(n2, n3 - 1);
        if (Double.isNaN(d4) || Double.isNaN(d3)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d5 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d6 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        double d7 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d8 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (Double.isNaN(d5) || Double.isNaN(d6) || Double.isNaN(d7) || Double.isNaN(d8)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            xYItemRendererState.workingLine.setLine(d6, d5, d8, d7);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            xYItemRendererState.workingLine.setLine(d5, d6, d7, d8);
        }
        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
            this.drawFirstPassShape(graphics2D, n, n2, n3, xYItemRendererState.workingLine);
        }
    }

    protected void drawFirstPassShape(Graphics2D graphics2D, int n, int n2, int n3, Shape shape) {
        graphics2D.setStroke(this.getItemStroke(n2, n3));
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        graphics2D.draw(shape);
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = xYDataset.getXValue(n2, n3);
        double d2 = xYDataset.getYValue(n2, n3);
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        State state = (State)xYItemRendererState;
        if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
            float f = (float)d3;
            float f2 = (float)d4;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                f = (float)d4;
                f2 = (float)d3;
            }
            if (state.isLastPointGood()) {
                state.seriesPath.lineTo(f, f2);
            } else {
                state.seriesPath.moveTo(f, f2);
            }
            state.setLastPointGood(true);
        } else {
            state.setLastPointGood(false);
        }
        if (n3 == xYDataset.getItemCount(n2) - 1) {
            this.drawFirstPassShape(graphics2D, n, n2, n3, state.seriesPath);
        }
    }

    protected void drawSecondaryPass(Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, Rectangle2D rectangle2D, ValueAxis valueAxis2, CrosshairState crosshairState, EntityCollection entityCollection) {
        Shape shape = null;
        double d = xYDataset.getXValue(n2, n3);
        double d2 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.getItemShapeVisible(n2, n3)) {
            Shape shape2 = this.getItemShape(n2, n3);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape2 = ShapeUtilities.createTranslatedShape((Shape)shape2, (double)d4, (double)d3);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape2 = ShapeUtilities.createTranslatedShape((Shape)shape2, (double)d3, (double)d4);
            }
            shape = shape2;
            if (shape2.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n2, n3)) {
                    if (this.useFillPaint) {
                        graphics2D.setPaint(this.getItemFillPaint(n2, n3));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n2, n3));
                    }
                    graphics2D.fill(shape2);
                    if (this.getDrawOutlines()) {
                        if (this.getUseOutlinePaint()) {
                            graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                        } else {
                            graphics2D.setPaint(this.getItemPaint(n2, n3));
                        }
                        graphics2D.draw(shape2);
                    }
                } else if (this.drawOutlines) {
                    if (this.getUseOutlinePaint()) {
                        graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n2, n3));
                    }
                    graphics2D.draw(shape2);
                }
            }
        }
        this.updateCrosshairValues(crosshairState, d, d2, d3, d4, xYPlot.getOrientation());
        if (entityCollection != null) {
            this.addEntity(entityCollection, shape, xYDataset, n2, n3, d3, d4);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            boolean bl = this.getItemShapeVisible(n2, 0);
            Shape shape = this.getSeriesShape(n2);
            boolean bl2 = this.getItemShapeFilled(n2, 0);
            Paint paint = this.useFillPaint ? this.getSeriesFillPaint(n2) : this.getSeriesPaint(n2);
            boolean bl3 = this.drawOutlines;
            Paint paint2 = this.useOutlinePaint ? this.getSeriesOutlinePaint(n2) : this.getSeriesPaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            boolean bl4 = this.getItemLineVisible(n2, 0);
            Stroke stroke2 = this.getSeriesStroke(n2);
            Paint paint3 = this.getSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, bl, shape, bl2, paint, bl3, paint2, stroke, bl4, new Line2D.Double(-7.0, 0.0, 7.0, 0.0), stroke2, paint3);
        }
        return legendItem;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)object;
        if (!ObjectUtilities.equal((Object)this.linesVisible, (Object)xYLineAndShapeRenderer.linesVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.seriesLinesVisible, (Object)xYLineAndShapeRenderer.seriesLinesVisible)) {
            return false;
        }
        if (this.defaultLinesVisible != xYLineAndShapeRenderer.defaultLinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.shapesVisible, (Object)xYLineAndShapeRenderer.shapesVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.seriesShapesVisible, (Object)xYLineAndShapeRenderer.seriesShapesVisible)) {
            return false;
        }
        if (this.defaultShapesVisible != xYLineAndShapeRenderer.defaultShapesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.shapesFilled, (Object)xYLineAndShapeRenderer.shapesFilled)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.seriesShapesFilled, (Object)xYLineAndShapeRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.defaultShapesFilled != xYLineAndShapeRenderer.defaultShapesFilled) {
            return false;
        }
        if (this.drawOutlines != xYLineAndShapeRenderer.drawOutlines) {
            return false;
        }
        return this.useOutlinePaint == xYLineAndShapeRenderer.useOutlinePaint;
    }

    public static class State
    extends XYItemRendererState {
        public GeneralPath seriesPath;
        private boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean bl) {
            this.lastPointGood = bl;
        }
    }
}

