/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private UnitType gapThresholdType = UnitType.RELATIVE;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;
    private boolean drawSeriesLineAsPath;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int n) {
        this(n, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if ((n & 1) != 0) {
            this.plotShapes = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
        this.drawSeriesLineAsPath = false;
    }

    public boolean getDefaultShapesVisible() {
        return this.plotShapes;
    }

    public void setDefaultShapesVisible(boolean bl) {
        if (this.plotShapes != bl) {
            this.plotShapes = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        if (this.plotShapes != bl) {
            this.plotShapes = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtilities.valueOf((boolean)bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean bl) {
        this.defaultShapesFilled = bl;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public UnitType getGapThresholdType() {
        return this.gapThresholdType;
    }

    public void setGapThresholdType(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'thresholdType' argument.");
        }
        this.gapThresholdType = unitType;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d) {
        this.gapThreshold = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        if (this.plotImages != bl) {
            this.plotImages = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
        this.drawSeriesLineAsPath = bl;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = xYDataset.getSeriesName(n2);
            Shape shape = this.getSeriesShape(n2);
            boolean bl = this.getSeriesShapesFilled(n2);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            Paint paint3 = paint;
            Stroke stroke2 = this.getSeriesStroke(n2);
            legendItem = new LegendItem(string, string2, this.plotShapes, shape, bl, paint, true, paint2, stroke, this.plotLines, new Line2D.Float(-7.0f, 0.0f, 7.0f, 0.0f), stroke2, paint3);
        }
        return legendItem;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        return state;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Image image;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.getPlotLines()) {
            State state;
            if (n2 == 0 && this.drawSeriesLineAsPath) {
                state = (State)xYItemRendererState;
                state.seriesPath.reset();
                state.lastPointGood = false;
            }
            if (this.drawSeriesLineAsPath) {
                state = (State)xYItemRendererState;
                if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
                    float f = (float)d3;
                    float f2 = (float)d4;
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        f = (float)d4;
                        f2 = (float)d3;
                    }
                    if (state.isLastPointGood()) {
                        state.seriesPath.lineTo(f, f2);
                    } else {
                        state.seriesPath.moveTo(f, f2);
                    }
                    state.setLastPointGood(true);
                } else {
                    state.setLastPointGood(false);
                }
                if (n2 == xYDataset.getItemCount(n) - 1) {
                    graphics2D.setStroke(this.getSeriesStroke(n));
                    graphics2D.setPaint(this.getSeriesPaint(n));
                    graphics2D.draw(state.seriesPath);
                }
            } else if (n2 != 0) {
                double d5 = xYDataset.getXValue(n, n2 - 1);
                double d6 = xYDataset.getYValue(n, n2 - 1);
                if (!Double.isNaN(d5) && !Double.isNaN(d6)) {
                    boolean bl = true;
                    if (this.getPlotDiscontinuous()) {
                        int n4 = xYDataset.getItemCount(n);
                        double d7 = xYDataset.getXValue(n, 0);
                        double d8 = xYDataset.getXValue(n, n4 - 1);
                        if (this.gapThresholdType == UnitType.ABSOLUTE) {
                            bl = Math.abs(d - d5) <= this.gapThreshold;
                        } else {
                            boolean bl2 = bl = Math.abs(d - d5) <= (d8 - d7) / (double)n4 * this.getGapThreshold();
                        }
                    }
                    if (bl) {
                        double d9 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
                        double d10 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                        if (Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d3) || Double.isNaN(d4)) {
                            return;
                        }
                        if (plotOrientation == PlotOrientation.HORIZONTAL) {
                            xYItemRendererState.workingLine.setLine(d10, d9, d4, d3);
                        } else if (plotOrientation == PlotOrientation.VERTICAL) {
                            xYItemRendererState.workingLine.setLine(d9, d10, d3, d4);
                        }
                        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                            graphics2D.draw(xYItemRendererState.workingLine);
                        }
                    }
                }
            }
        }
        if (this.getPlotShapes()) {
            Shape shape2 = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape2 = ShapeUtilities.createTranslatedShape((Shape)shape2, (double)d4, (double)d3);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape2 = ShapeUtilities.createTranslatedShape((Shape)shape2, (double)d3, (double)d4);
            }
            if (shape2.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill(shape2);
                } else {
                    graphics2D.draw(shape2);
                }
            }
            shape = shape2;
        }
        if (this.getPlotImages() && (image = this.getImage(xYPlot, n, n2, d3, d4)) != null) {
            Point point = this.getImageHotspot(xYPlot, n, n2, d3, d4, image);
            graphics2D.drawImage(image, (int)(d3 - point.getX()), (int)(d4 - point.getY()), null);
            shape = new Rectangle2D.Double(d3 - point.getX(), d4 - point.getY(), image.getWidth(null), image.getHeight(null));
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d3, d4, d2 < 0.0);
        }
        this.updateCrosshairValues(crosshairState, d, d2, d3, d4, plotOrientation);
        if (entityCollection != null) {
            this.addEntity(entityCollection, shape, xYDataset, n, n2, d3, d4);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYItemRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
        if (this.plotShapes != standardXYItemRenderer.plotShapes) {
            return false;
        }
        if (this.plotLines != standardXYItemRenderer.plotLines) {
            return false;
        }
        if (this.plotImages != standardXYItemRenderer.plotImages) {
            return false;
        }
        if (this.plotDiscontinuous != standardXYItemRenderer.plotDiscontinuous) {
            return false;
        }
        if (this.gapThresholdType != standardXYItemRenderer.gapThresholdType) {
            return false;
        }
        if (this.gapThreshold != standardXYItemRenderer.gapThreshold) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.shapesFilled, (Object)standardXYItemRenderer.shapesFilled);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    public static class State
    extends XYItemRendererState {
        public GeneralPath seriesPath;
        private boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean bl) {
            this.lastPointGood = bl;
        }
    }
}

