/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Stack;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class StackedXYAreaRenderer
extends XYAreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private Paint shapePaint = null;
    private Stroke shapeStroke = null;

    public StackedXYAreaRenderer() {
        this(4);
    }

    public StackedXYAreaRenderer(int n) {
        this(n, null, null);
    }

    public StackedXYAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public Paint getShapePaint() {
        return this.shapePaint;
    }

    public Stroke getShapeStroke() {
        return this.shapeStroke;
    }

    public void setShapePaint(Paint paint) {
        this.shapePaint = paint;
    }

    public void setShapeStroke(Stroke stroke) {
        this.shapeStroke = stroke;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new StackedXYAreaRendererState(plotRenderingInfo);
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)xYDataset);
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        StackedXYAreaRendererState stackedXYAreaRendererState = (StackedXYAreaRendererState)xYItemRendererState;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n4 = tableXYDataset.getItemCount();
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        boolean bl = false;
        if (number2 == null) {
            number2 = new Double(0.0);
            bl = true;
        }
        double d = this.getPreviousHeight(xYDataset, n, n2);
        double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d3 = valueAxis2.valueToJava2D(number2.doubleValue() + d, rectangle2D, xYPlot.getRangeAxisEdge());
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        if (n3 == 0) {
            if (n2 == 0) {
                stackedXYAreaRendererState.setSeriesArea(new Polygon());
                stackedXYAreaRendererState.setLastSeriesPoints(stackedXYAreaRendererState.getCurrentSeriesPoints());
                stackedXYAreaRendererState.setCurrentSeriesPoints(new Stack());
                double d4 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d2, (int)d4);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d4, (int)d2);
                }
            }
            if (plotOrientation == PlotOrientation.VERTICAL) {
                Point point = new Point((int)d2, (int)d3);
                stackedXYAreaRendererState.getSeriesArea().addPoint((int)point.getX(), (int)point.getY());
                stackedXYAreaRendererState.getCurrentSeriesPoints().push(point);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                stackedXYAreaRendererState.getSeriesArea().addPoint((int)d3, (int)d2);
            }
            if (this.getPlotLines() && n2 > 0) {
                Number number3 = xYDataset.getX(n, n2 - 1);
                Number number4 = xYDataset.getY(n, n2 - 1);
                double d5 = this.getPreviousHeight(xYDataset, n, n2 - 1);
                double d6 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
                double d7 = valueAxis2.valueToJava2D(number4.doubleValue() + d5, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getLine().setLine(d6, d7, d2, d3);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getLine().setLine(d7, d6, d3, d2);
                }
                graphics2D.draw(stackedXYAreaRendererState.getLine());
            }
            if (this.getPlotArea() && n2 > 0 && n2 == n4 - 1) {
                double d8 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d2, (int)d8);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d8, (int)d2);
                }
                if (n != 0) {
                    Stack stack = stackedXYAreaRendererState.getLastSeriesPoints();
                    while (!stack.empty()) {
                        Point point = (Point)stack.pop();
                        stackedXYAreaRendererState.getSeriesArea().addPoint((int)point.getX(), (int)point.getY());
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.fill(stackedXYAreaRendererState.getSeriesArea());
                if (this.isOutline()) {
                    graphics2D.setStroke(xYPlot.getOutlineStroke());
                    graphics2D.setPaint(xYPlot.getOutlinePaint());
                    graphics2D.draw(stackedXYAreaRendererState.getSeriesArea());
                }
            }
            this.updateCrosshairValues(crosshairState, number.doubleValue(), number2.doubleValue(), d2, d3, plotOrientation);
        } else if (n3 == 1) {
            EntityCollection entityCollection;
            Shape shape = null;
            if (this.getPlotShapes()) {
                shape = this.getItemShape(n, n2);
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d2, (double)d3);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d3, (double)d2);
                }
                if (!bl) {
                    if (this.getShapePaint() != null) {
                        graphics2D.setPaint(this.getShapePaint());
                    } else {
                        graphics2D.setPaint(paint);
                    }
                    if (this.getShapeStroke() != null) {
                        graphics2D.setStroke(this.getShapeStroke());
                    } else {
                        graphics2D.setStroke(stroke);
                    }
                    graphics2D.draw(shape);
                }
            } else if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, 6.0, 6.0);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = new Rectangle2D.Double(d3 - 3.0, d2 - 3.0, 6.0, 6.0);
            }
            if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null && !bl) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
                entityCollection.add(xYItemEntity);
            }
        }
    }

    protected double getPreviousHeight(XYDataset xYDataset, int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number = xYDataset.getY(n3, n2);
            if (number != null) {
                d += number.doubleValue();
            }
            ++n3;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYAreaRenderer) || !super.equals(object)) {
            return false;
        }
        StackedXYAreaRenderer stackedXYAreaRenderer = (StackedXYAreaRenderer)object;
        if (!ObjectUtilities.equal((Object)this.shapePaint, (Object)stackedXYAreaRenderer.shapePaint)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.shapeStroke, (Object)stackedXYAreaRenderer.shapeStroke);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static class StackedXYAreaRendererState
    extends XYItemRendererState {
        private Polygon seriesArea = null;
        private Line2D line = null;
        private Stack lastSeriesPoints = new Stack();
        private Stack currentSeriesPoints = null;

        public StackedXYAreaRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public Polygon getSeriesArea() {
            return this.seriesArea;
        }

        public void setSeriesArea(Polygon polygon) {
            this.seriesArea = polygon;
        }

        public Line2D getLine() {
            return this.line;
        }

        public Stack getCurrentSeriesPoints() {
            return this.currentSeriesPoints;
        }

        public void setCurrentSeriesPoints(Stack stack) {
            this.currentSeriesPoints = stack;
        }

        public Stack getLastSeriesPoints() {
            return this.lastSeriesPoints;
        }

        public void setLastSeriesPoints(Stack stack) {
            this.lastSeriesPoints = stack;
        }
    }
}

