/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HighLow {
    public static final int OPEN = 0;
    public static final int CLOSE = 1;
    private Line2D line;
    private Rectangle2D bounds;
    private double open;
    private double close;
    private Stroke stroke;
    private Paint paint;
    private double tickSize = 2.0;

    public HighLow(double d, double d2, double d3) {
        this(d, d2, d3, d2, d3, new BasicStroke(), Color.blue);
    }

    public HighLow(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, new BasicStroke(), Color.blue);
    }

    public HighLow(double d, double d2, double d3, double d4, double d5, Stroke stroke, Paint paint) {
        this.line = new Line2D.Double(d, d2, d, d3);
        this.bounds = new Rectangle2D.Double(d - this.tickSize, d2, 2.0 * this.tickSize, d3 - d2);
        this.open = d4;
        this.close = d5;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void setTickSize(double d) {
        this.tickSize = d;
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public Line2D getLine() {
        return this.line;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public double getValue(int n) {
        if (n == 0) {
            return this.open;
        }
        return this.close;
    }

    public void setValue(int n, double d) {
        if (n == 0) {
            this.open = d;
        } else {
            this.close = d;
        }
    }

    public Line2D getOpenTickLine() {
        return this.getTickLine(this.getLine().getX1(), this.getValue(0), -1.0 * this.getTickSize());
    }

    public Line2D getCloseTickLine() {
        return this.getTickLine(this.getLine().getX1(), this.getValue(1), this.getTickSize());
    }

    private Line2D getTickLine(double d, double d2, double d3) {
        return new Line2D.Double(d, d2, d + d3, d2);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }
}

