/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private double margin;
    private double translatedRangeZero;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d, boolean bl) {
        super(d);
        this.margin = d;
        this.centerBarAtStartValue = bl;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        return xYItemRendererState;
    }

    public void setMargin(double d) {
        this.margin = d;
        super.setMargin(d);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        Paint paint2 = this.getItemOutlinePaint(n, n2);
        Number number = intervalXYDataset.getY(n, n2);
        if (number == null) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d = valueAxis2.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d2 = intervalXYDataset.getStartXValue(n, n2);
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        double d4 = intervalXYDataset.getEndXValue(n, n2);
        double d5 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        double d6 = Math.max(1.0, Math.abs(d5 - d3));
        double d7 = Math.abs(d - this.translatedRangeZero);
        if (this.centerBarAtStartValue) {
            d3 -= d6 / 2.0;
        }
        if (this.margin > 0.0) {
            double d8 = d6 * this.margin;
            d6 -= d8;
            d3 += d8 / 2.0;
        }
        int n4 = xYDataset.getSeriesCount();
        double d9 = d6 / (double)n4;
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(this.translatedRangeZero, d), d3 - d9 * (double)(n4 - n), d7, d9);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d3 + d9 * (double)n, Math.min(this.translatedRangeZero, d), d9, d7);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d5 - d3) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

