/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StatisticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("StatisticalBarRenderer.drawCategoryItem() : the data should be of type StatisticalCategoryDataset only.");
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n, int n2) {
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d2 = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d += (double)n * (categoryItemRendererState.getBarWidth() + d2);
        } else {
            d += (double)n * categoryItemRendererState.getBarWidth();
        }
        Number number = statisticalCategoryDataset.getMeanValue(n, n2);
        double d3 = number.doubleValue();
        double d4 = 0.0;
        double d5 = this.getLowerClip();
        double d6 = this.getUpperClip();
        if (d6 <= 0.0) {
            if (d3 >= d6) {
                return;
            }
            d4 = d6;
            if (d3 <= d5) {
                d3 = d5;
            }
        } else if (d5 <= 0.0) {
            if (d3 >= d6) {
                d3 = d6;
            } else if (d3 <= d5) {
                d3 = d5;
            }
        } else {
            if (d3 <= d5) {
                return;
            }
            d4 = this.getLowerClip();
            if (d3 >= d6) {
                d3 = d6;
            }
        }
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        double d8 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        double d9 = Math.min(d8, d7);
        double d10 = categoryItemRendererState.getBarWidth();
        double d11 = Math.abs(d8 - d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d9, d, d11, d10);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        double d12 = statisticalCategoryDataset.getStdDevValue(n, n2).doubleValue();
        double d13 = valueAxis.valueToJava2D(number.doubleValue() + d12, rectangle2D, rectangleEdge2);
        double d14 = valueAxis.valueToJava2D(number.doubleValue() - d12, rectangle2D, rectangleEdge2);
        Line2D.Double double_2 = null;
        double_2 = new Line2D.Double(d14, d + d10 / 2.0, d13, d + d10 / 2.0);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d13, d + d10 * 0.25, d13, d + d10 * 0.75);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d14, d + d10 * 0.25, d14, d + d10 * 0.75);
        graphics2D.draw(double_2);
    }

    protected void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n, int n2) {
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d2 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d += (double)n * (categoryItemRendererState.getBarWidth() + d2);
        } else {
            d += (double)n * categoryItemRendererState.getBarWidth();
        }
        Number number = statisticalCategoryDataset.getMeanValue(n, n2);
        double d3 = number.doubleValue();
        double d4 = 0.0;
        double d5 = this.getLowerClip();
        double d6 = this.getUpperClip();
        if (d6 <= 0.0) {
            if (d3 >= d6) {
                return;
            }
            d4 = d6;
            if (d3 <= d5) {
                d3 = d5;
            }
        } else if (d5 <= 0.0) {
            if (d3 >= d6) {
                d3 = d6;
            } else if (d3 <= d5) {
                d3 = d5;
            }
        } else {
            if (d3 <= d5) {
                return;
            }
            d4 = this.getLowerClip();
            if (d3 >= d6) {
                d3 = d6;
            }
        }
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        double d8 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        double d9 = Math.min(d8, d7);
        double d10 = categoryItemRendererState.getBarWidth();
        double d11 = Math.abs(d8 - d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d9, d10, d11);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        double d12 = statisticalCategoryDataset.getStdDevValue(n, n2).doubleValue();
        double d13 = valueAxis.valueToJava2D(number.doubleValue() + d12, rectangle2D, rectangleEdge2);
        double d14 = valueAxis.valueToJava2D(number.doubleValue() - d12, rectangle2D, rectangleEdge2);
        Line2D.Double double_2 = null;
        double_2 = new Line2D.Double(d + d10 / 2.0, d14, d + d10 / 2.0, d13);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d10 / 2.0 - 5.0, d13, d + d10 / 2.0 + 5.0, d13);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d10 / 2.0 - 5.0, d14, d + d10 / 2.0 + 5.0, d14);
        graphics2D.draw(double_2);
    }
}

