/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AreaRendererEndType;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class AreaRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private AreaRendererEndType endType = AreaRendererEndType.TAPER;

    public AreaRendererEndType getEndType() {
        return this.endType;
    }

    public void setEndType(AreaRendererEndType areaRendererEndType) {
        if (areaRendererEndType == null) {
            throw new IllegalArgumentException("Null 'type' argument.");
        }
        this.endType = areaRendererEndType;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = categoryDataset.getRowKey(n2).toString();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesOutlineStroke(n2);
        return new LegendItem(string, string2, double_, paint, stroke, paint2);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            Object object;
            Number number2;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
            int n4 = categoryDataset.getColumnCount();
            float f = (float)categoryAxis.getCategoryStart(n2, n4, rectangle2D, rectangleEdge);
            float f2 = (float)categoryAxis.getCategoryMiddle(n2, n4, rectangle2D, rectangleEdge);
            float f3 = (float)categoryAxis.getCategoryEnd(n2, n4, rectangle2D, rectangleEdge);
            f = Math.round(f);
            f2 = Math.round(f2);
            f3 = Math.round(f3);
            if (this.endType == AreaRendererEndType.TRUNCATE) {
                if (n2 == 0) {
                    f = f2;
                } else if (n2 == this.getColumnCount() - 1) {
                    f3 = f2;
                }
            }
            double d = number.doubleValue();
            double d2 = 0.0;
            if (n2 > 0 && (number2 = categoryDataset.getValue(n, n2 - 1)) != null) {
                d2 = (number2.doubleValue() + d) / 2.0;
            }
            double d3 = 0.0;
            if (n2 < categoryDataset.getColumnCount() - 1 && (object = categoryDataset.getValue(n, n2 + 1)) != null) {
                d3 = (((Number)object).doubleValue() + d) / 2.0;
            }
            object = categoryPlot.getRangeAxisEdge();
            float f4 = (float)valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)object);
            float f5 = (float)valueAxis.valueToJava2D(d, rectangle2D, (RectangleEdge)object);
            float f6 = (float)valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)object);
            float f7 = (float)valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)object);
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            GeneralPath generalPath = new GeneralPath();
            if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath.moveTo(f, f7);
                generalPath.lineTo(f, f4);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f3, f6);
                generalPath.lineTo(f3, f7);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath.moveTo(f7, f);
                generalPath.lineTo(f4, f);
                generalPath.lineTo(f5, f2);
                generalPath.lineTo(f6, f3);
                generalPath.lineTo(f7, f3);
            }
            generalPath.closePath();
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(generalPath);
            if (this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, f2, f5, number.doubleValue() < 0.0);
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (categoryToolTipGenerator != null) {
                    string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                Comparable comparable = categoryDataset.getColumnKey(n2);
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(generalPath, string, string2, categoryDataset, n, comparable, n2);
                entityCollection.add(categoryItemEntity);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

