/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

public class RingPlot
extends PiePlot
implements Cloneable,
Serializable {
    private boolean separatorsVisible = true;
    private transient Stroke separatorStroke = new BasicStroke(0.5f);
    private transient Paint separatorPaint = Color.gray;
    private double innerSeparatorExtension = 0.2;
    private double outerSeparatorExtension = 0.2;

    public RingPlot(PieDataset pieDataset) {
        super(pieDataset);
    }

    public boolean getSeparatorsVisible() {
        return this.separatorsVisible;
    }

    public void setSeparatorsVisible(boolean bl) {
        this.separatorsVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeparatorStroke() {
        return this.separatorStroke;
    }

    public void setSeparatorStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.separatorStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeparatorPaint() {
        return this.separatorPaint;
    }

    public void setSeparatorPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.separatorPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInnerSeparatorExtension() {
        return this.innerSeparatorExtension;
    }

    public void setInnerSeparatorExtension(double d) {
        this.innerSeparatorExtension = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getOuterSeparatorExtension() {
        return this.outerSeparatorExtension;
    }

    public void setOuterSeparatorExtension(double d) {
        this.outerSeparatorExtension = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected void drawItem(Graphics2D graphics2D, int n, Rectangle2D rectangle2D, PiePlotState piePlotState, int n2) {
        PieDataset pieDataset = this.getDataset();
        Number number = pieDataset.getValue(n);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = 0.0;
        Rotation rotation = this.getDirection();
        if (rotation == Rotation.CLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 - d / piePlotState.getTotal() * 360.0;
        } else if (rotation == Rotation.ANTICLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 + d / piePlotState.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double d4 = d3 - d2;
        if (Math.abs(d4) > this.getMinimumArcAngleToDraw()) {
            double d5 = 0.0;
            double d6 = this.getMaximumExplodePercent();
            if (d6 > 0.0) {
                d5 = this.getExplodePercent(n) / d6;
            }
            Rectangle2D rectangle2D2 = this.getArcBounds(piePlotState.getPieArea(), piePlotState.getExplodedPieArea(), d2, d4, d5);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d4, 0);
            RectangleInsets rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.1, 0.1, 0.1, 0.1);
            Rectangle2D.Double double_2 = new Rectangle2D.Double();
            ((Rectangle2D)double_2).setRect(rectangle2D2);
            rectangleInsets.trim((Rectangle2D)double_2);
            Arc2D.Double double_3 = new Arc2D.Double(double_2, d2 + d4, -d4, 0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
            generalPath.append(double_.getPathIterator(null), false);
            generalPath.append(double_3.getPathIterator(null), true);
            generalPath.closePath();
            Line2D.Double double_4 = new Line2D.Double(double_3.getEndPoint(), double_.getStartPoint());
            if (n2 == 0) {
                Paint paint = this.getShadowPaint();
                double d7 = this.getShadowXOffset();
                double d8 = this.getShadowYOffset();
                if (paint != null) {
                    Shape shape = ShapeUtilities.createTranslatedShape((Shape)generalPath, (double)((float)d7), (double)((float)d8));
                    graphics2D.setPaint(paint);
                    graphics2D.fill(shape);
                }
            } else if (n2 == 1) {
                Object object;
                Paint paint = this.getSectionPaint(n);
                graphics2D.setPaint(paint);
                graphics2D.fill(generalPath);
                Paint paint2 = this.getSectionOutlinePaint(n);
                Stroke stroke = this.getSectionOutlineStroke(n);
                if (paint2 != null && stroke != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(generalPath);
                }
                if (this.separatorsVisible) {
                    object = this.extendLine(double_4, this.innerSeparatorExtension, this.innerSeparatorExtension);
                    graphics2D.setStroke(this.separatorStroke);
                    graphics2D.setPaint(this.separatorPaint);
                    graphics2D.draw((Shape)object);
                }
                if (piePlotState.getInfo() != null && (object = piePlotState.getInfo().getOwner().getEntityCollection()) != null) {
                    Comparable comparable = pieDataset.getKey(n);
                    String string = null;
                    PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
                    if (pieToolTipGenerator != null) {
                        string = pieToolTipGenerator.generateToolTip(pieDataset, comparable);
                    }
                    String string2 = null;
                    PieURLGenerator pieURLGenerator = this.getURLGenerator();
                    if (pieURLGenerator != null) {
                        string2 = pieURLGenerator.generateURL(pieDataset, comparable, this.getPieIndex());
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_, pieDataset, this.getPieIndex(), n, comparable, string, string2);
                    object.add(pieSectionEntity);
                }
            }
        }
        piePlotState.setLatestAngle(d3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RingPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RingPlot ringPlot = (RingPlot)object;
        if (this.separatorsVisible != ringPlot.separatorsVisible) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.separatorStroke, (Object)ringPlot.separatorStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.separatorPaint, (Object)ringPlot.separatorPaint)) {
            return false;
        }
        if (this.innerSeparatorExtension != ringPlot.innerSeparatorExtension) {
            return false;
        }
        return this.outerSeparatorExtension == ringPlot.outerSeparatorExtension;
    }

    private Line2D extendLine(Line2D line2D, double d, double d2) {
        if (line2D == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        double d3 = line2D.getX1();
        double d4 = line2D.getX2();
        double d5 = d4 - d3;
        double d6 = line2D.getY1();
        double d7 = line2D.getY2();
        double d8 = d7 - d6;
        return new Line2D.Double(d3 -= d * d5, d6 -= d * d8, d4 += d2 * d5, d7 += d2 * d8);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.separatorStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.separatorPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.separatorStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.separatorPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

