/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class PlotRenderingInfo
implements Cloneable,
Serializable {
    private transient ChartRenderingInfo owner;
    private transient Rectangle2D plotArea;
    private transient Rectangle2D dataArea;
    private List subplotInfo;

    public PlotRenderingInfo(ChartRenderingInfo chartRenderingInfo) {
        this.owner = chartRenderingInfo;
        this.dataArea = new Rectangle2D.Double();
        this.subplotInfo = new ArrayList();
    }

    public ChartRenderingInfo getOwner() {
        return this.owner;
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(Rectangle2D rectangle2D) {
        this.plotArea = rectangle2D;
    }

    public Rectangle2D getDataArea() {
        return this.dataArea;
    }

    public void setDataArea(Rectangle2D rectangle2D) {
        this.dataArea = rectangle2D;
    }

    public int getSubplotCount() {
        return this.subplotInfo.size();
    }

    public void addSubplotInfo(PlotRenderingInfo plotRenderingInfo) {
        this.subplotInfo.add(plotRenderingInfo);
    }

    public PlotRenderingInfo getSubplotInfo(int n) {
        return (PlotRenderingInfo)this.subplotInfo.get(n);
    }

    public int getSubplotIndex(Point2D point2D) {
        int n = this.getSubplotCount();
        int n2 = 0;
        while (n2 < n) {
            PlotRenderingInfo plotRenderingInfo = this.getSubplotInfo(n2);
            Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
            if (rectangle2D.contains(point2D)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlotRenderingInfo)) {
            return false;
        }
        PlotRenderingInfo plotRenderingInfo = (PlotRenderingInfo)object;
        if (!ObjectUtilities.equal((Object)this.dataArea, (Object)plotRenderingInfo.dataArea)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.plotArea, (Object)plotRenderingInfo.plotArea)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.subplotInfo, (Object)plotRenderingInfo.subplotInfo);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.dataArea, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.plotArea, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dataArea = (Rectangle2D)SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.plotArea = (Rectangle2D)SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }
}

