/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.plot.PieLabelRecord;

public class PieLabelDistributor {
    private List labels;
    private double minGap = 4.0;

    public PieLabelDistributor(int n) {
        this.labels = new ArrayList(n);
    }

    public PieLabelRecord getPieLabelRecord(int n) {
        return (PieLabelRecord)this.labels.get(n);
    }

    public void addPieLabelRecord(PieLabelRecord pieLabelRecord) {
        this.labels.add(pieLabelRecord);
    }

    public int getItemCount() {
        return this.labels.size();
    }

    public void distributeLabels(double d, double d2) {
        this.sort();
        if (this.isOverlap()) {
            this.adjustInwards();
        }
        if (this.isOverlap()) {
            this.adjustDownwards(d, d2);
        }
        if (this.isOverlap()) {
            this.adjustUpwards(d, d2);
        }
        if (this.isOverlap()) {
            this.spreadEvenly(d, d2);
        }
    }

    private boolean isOverlap() {
        double d = 0.0;
        int n = 0;
        while (n < this.labels.size()) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(n);
            if (d > pieLabelRecord.getLowerY()) {
                return true;
            }
            d = pieLabelRecord.getUpperY();
            ++n;
        }
        return false;
    }

    protected void adjustInwards() {
        int n = 0;
        int n2 = this.labels.size() - 1;
        while (n2 > n) {
            double d;
            PieLabelRecord pieLabelRecord;
            PieLabelRecord pieLabelRecord2;
            if (n < n2 - 1) {
                pieLabelRecord2 = this.getPieLabelRecord(n);
                pieLabelRecord = this.getPieLabelRecord(n + 1);
                if (pieLabelRecord.getLowerY() < pieLabelRecord2.getUpperY()) {
                    d = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
                    pieLabelRecord.setAllocatedY(pieLabelRecord.getAllocatedY() + d);
                }
            }
            pieLabelRecord2 = this.getPieLabelRecord(n2 - 1);
            pieLabelRecord = this.getPieLabelRecord(n2);
            if (pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY()) {
                d = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
                pieLabelRecord2.setAllocatedY(pieLabelRecord2.getAllocatedY() - d);
            }
            ++n;
            --n2;
        }
    }

    protected void adjustDownwards(double d, double d2) {
        int n = 0;
        while (n < this.labels.size() - 1) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(n);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(n + 1);
            if (pieLabelRecord2.getLowerY() < pieLabelRecord.getUpperY()) {
                pieLabelRecord2.setAllocatedY(Math.min(d + d2, pieLabelRecord.getUpperY() + this.minGap + pieLabelRecord2.getLabelHeight() / 2.0));
            }
            ++n;
        }
    }

    protected void adjustUpwards(double d, double d2) {
        int n = this.labels.size() - 1;
        while (n > 0) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(n);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(n - 1);
            if (pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY()) {
                pieLabelRecord2.setAllocatedY(Math.max(d, pieLabelRecord.getLowerY() - this.minGap - pieLabelRecord2.getLabelHeight() / 2.0));
            }
            --n;
        }
    }

    protected void spreadEvenly(double d, double d2) {
        double d3 = d;
        double d4 = 0.0;
        int n = 0;
        while (n < this.labels.size()) {
            d4 += this.getPieLabelRecord(n).getLabelHeight();
            ++n;
        }
        double d5 = d2 - d4;
        if (this.labels.size() > 1) {
            d5 /= (double)(this.labels.size() - 1);
        }
        int n2 = 0;
        while (n2 < this.labels.size()) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(n2);
            pieLabelRecord.setAllocatedY(d3 += pieLabelRecord.getLabelHeight() / 2.0);
            d3 = d3 + pieLabelRecord.getLabelHeight() / 2.0 + d5;
            ++n2;
        }
    }

    public void sort() {
        Collections.sort(this.labels);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.labels.size()) {
            string = String.valueOf(string) + this.getPieLabelRecord(n).toString() + "\n";
            ++n;
        }
        return string;
    }
}

