/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.AbstractPieItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;

public class StandardPieItemLabelGenerator
extends AbstractPieItemLabelGenerator
implements PieToolTipGenerator,
PieSectionLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({1}, {2})";
    public static final String DEFAULT_SECTION_LABEL_FORMAT = "{0} = {1}";

    public StandardPieItemLabelGenerator() {
        this(DEFAULT_SECTION_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String string) {
        this(string, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(string, numberFormat, numberFormat2);
    }

    public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
        String string = null;
        if (pieDataset != null) {
            Object[] objectArray = this.createItemArray(pieDataset, comparable);
            string = MessageFormat.format(this.getLabelFormat(), objectArray);
        }
        return string;
    }

    public String generateToolTip(PieDataset pieDataset, Comparable comparable) {
        return this.generateSectionLabel(pieDataset, comparable);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

