/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;
import org.jfree.util.PublicCloneable;

public class BlockContainer
extends AbstractBlock
implements Block,
Cloneable,
PublicCloneable,
Serializable {
    private List blocks;
    private Arrangement arrangement;

    public BlockContainer() {
        this(new BorderArrangement());
    }

    public BlockContainer(Arrangement arrangement) {
        if (arrangement == null) {
            throw new IllegalArgumentException("Null 'arrangement' argument.");
        }
        this.arrangement = arrangement;
        this.blocks = new ArrayList();
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(Arrangement arrangement) {
        if (arrangement == null) {
            throw new IllegalArgumentException("Null 'arrangement' argument.");
        }
        this.arrangement = arrangement;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public List getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public void add(Block block) {
        this.add(block, null);
    }

    public void add(Block block, Object object) {
        this.blocks.add(block);
        this.arrangement.add(block, object);
    }

    public void clear() {
        this.blocks.clear();
        this.arrangement.clear();
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return this.arrangement.arrange(this, rectangleConstraint, graphics2D);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        rectangle2D2 = this.trimMargin(rectangle2D2);
        this.drawBorder(graphics2D, rectangle2D2);
        rectangle2D2 = this.trimBorder(rectangle2D2);
        rectangle2D2 = this.trimPadding(rectangle2D2);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(rectangle2D2.getX(), rectangle2D2.getY());
        Iterator iterator = this.blocks.iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            block.draw(graphics2D, block.getBounds());
        }
        graphics2D.setTransform(affineTransform);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlockContainer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BlockContainer blockContainer = (BlockContainer)object;
        if (!this.arrangement.equals(blockContainer.arrangement)) {
            return false;
        }
        return this.blocks.equals(blockContainer.blocks);
    }

    public Object clone() throws CloneNotSupportedException {
        BlockContainer blockContainer = (BlockContainer)super.clone();
        return blockContainer;
    }
}

