/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYLineAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private transient Stroke stroke;
    private transient Paint paint;

    public XYLineAnnotation(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, new BasicStroke(1.0f), Color.black);
    }

    public XYLineAnnotation(double d, double d2, double d3, double d4, Stroke stroke, Paint paint) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            f = (float)valueAxis.valueToJava2D(this.x1, rectangle2D, rectangleEdge);
            f3 = (float)valueAxis2.valueToJava2D(this.y1, rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis.valueToJava2D(this.x2, rectangle2D, rectangleEdge);
            f4 = (float)valueAxis2.valueToJava2D(this.y2, rectangle2D, rectangleEdge2);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f3 = (float)valueAxis.valueToJava2D(this.x1, rectangle2D, rectangleEdge);
            f = (float)valueAxis2.valueToJava2D(this.y1, rectangle2D, rectangleEdge2);
            f4 = (float)valueAxis.valueToJava2D(this.x2, rectangle2D, rectangleEdge);
            f2 = (float)valueAxis2.valueToJava2D(this.y2, rectangle2D, rectangleEdge2);
        }
        graphics2D.setPaint(this.paint);
        graphics2D.setStroke(this.stroke);
        Line2D.Float float_ = new Line2D.Float(f, f3, f2, f4);
        graphics2D.draw(float_);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, ShapeUtilities.createLineRegion((Line2D)float_, (float)1.0f), n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYLineAnnotation)) {
            return false;
        }
        XYLineAnnotation xYLineAnnotation = (XYLineAnnotation)object;
        if (this.x1 != xYLineAnnotation.x1) {
            return false;
        }
        if (this.y1 != xYLineAnnotation.y1) {
            return false;
        }
        if (this.x2 != xYLineAnnotation.x2) {
            return false;
        }
        if (this.y2 != xYLineAnnotation.y2) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.paint, (Object)xYLineAnnotation.paint)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.stroke, (Object)xYLineAnnotation.stroke);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x1);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x2);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y1);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y2);
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
    }
}

