/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYImageAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private double x;
    private double y;
    private Image image;

    public XYImageAnnotation(double d, double d2, Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        this.x = d;
        this.y = d2;
        this.image = image;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f3 = f2;
            f4 = f;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f3 = f;
            f4 = f2;
        }
        int n2 = this.image.getWidth(null);
        int n3 = this.image.getHeight(null);
        graphics2D.drawImage(this.image, (int)(f3 -= (float)n2 / 2.0f), (int)(f4 -= (float)n3 / 2.0f), null);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f3, f4, n2, n3), n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYImageAnnotation)) {
            return false;
        }
        XYImageAnnotation xYImageAnnotation = (XYImageAnnotation)object;
        if (this.x != xYImageAnnotation.x) {
            return false;
        }
        if (this.y != xYImageAnnotation.y) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.image, (Object)xYImageAnnotation.image);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

