/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;

public class PolarChartPanel
extends ChartPanel {
    private static final String POLAR_ZOOM_IN_ACTION_COMMAND = "Polar Zoom In";
    private static final String POLAR_ZOOM_OUT_ACTION_COMMAND = "Polar Zoom Out";
    private static final String POLAR_AUTO_RANGE_ACTION_COMMAND = "Polar Auto Range";

    public PolarChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, true);
    }

    public PolarChartPanel(JFreeChart jFreeChart, boolean bl) {
        super(jFreeChart, bl);
        this.checkChart(jFreeChart);
        this.setMinimumDrawWidth(200);
        this.setMinimumDrawHeight(200);
        this.setMaximumDrawWidth(2000);
        this.setMaximumDrawHeight(2000);
    }

    public void setChart(JFreeChart jFreeChart) {
        this.checkChart(jFreeChart);
        super.setChart(jFreeChart);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JPopupMenu jPopupMenu = super.createPopupMenu(bl, bl2, bl3, bl4);
        int n = this.getPopupMenuItem(jPopupMenu, "Zoom In");
        int n2 = this.getPopupMenuItem(jPopupMenu, "Zoom Out");
        int n3 = this.getPopupMenuItem(jPopupMenu, "Auto Range");
        if (bl4) {
            JMenuItem jMenuItem = new JMenuItem("Zoom In");
            jMenuItem.setActionCommand(POLAR_ZOOM_IN_ACTION_COMMAND);
            jMenuItem.addActionListener(this);
            JMenuItem jMenuItem2 = new JMenuItem("Zoom Out");
            jMenuItem2.setActionCommand(POLAR_ZOOM_OUT_ACTION_COMMAND);
            jMenuItem2.addActionListener(this);
            JMenuItem jMenuItem3 = new JMenuItem("Auto Range");
            jMenuItem3.setActionCommand(POLAR_AUTO_RANGE_ACTION_COMMAND);
            jMenuItem3.addActionListener(this);
            if (n != -1) {
                jPopupMenu.remove(n);
            } else {
                n = jPopupMenu.getComponentCount() - 1;
            }
            jPopupMenu.add((Component)jMenuItem, n);
            if (n2 != -1) {
                jPopupMenu.remove(n2);
            } else {
                n2 = n + 1;
            }
            jPopupMenu.add((Component)jMenuItem2, n2);
            if (n3 != -1) {
                jPopupMenu.remove(n3);
            } else {
                n3 = n2 + 1;
            }
            jPopupMenu.add((Component)jMenuItem3, n3);
        }
        return jPopupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(POLAR_ZOOM_IN_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.zoom(0.5);
        } else if (string.equals(POLAR_ZOOM_OUT_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.zoom(2.0);
        } else if (string.equals(POLAR_AUTO_RANGE_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.getAxis().setAutoRange(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void checkChart(JFreeChart jFreeChart) {
        Plot plot = jFreeChart.getPlot();
        if (!(plot instanceof PolarPlot)) {
            throw new IllegalArgumentException("plot is not a PolarPlot");
        }
    }

    private int getPopupMenuItem(JPopupMenu jPopupMenu, String string) {
        int n = -1;
        int n2 = 0;
        while (n == -1 && n2 < jPopupMenu.getComponentCount()) {
            JMenuItem jMenuItem;
            Component component = jPopupMenu.getComponent(n2);
            if (component instanceof JMenuItem && string.equals((jMenuItem = (JMenuItem)component).getText())) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

