/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * options.c
 *
 * standard options  handling
 */
#include <stdio.h>   
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"
#include "asm.h"
#include "options.h"
#include "olist.h"
#include "input.h"

extern BOOL poption(char *string);

extern int macstyle,ifstyle;

void BadOption(void)
{
	Error("Bad Option");
}
/* well-defined value */
BOOL checkval(EXPRESSION *q)
{
	if (!numericExpression(q) || q->isextern || q->relmode || !q->isdef) {
		BadOption();
		return(FALSE);
	}
	return(TRUE);
}
/* check for on or off */
BOOL checkon(char *string)
{
	return(!strcmp(string,"on") || (!strcmp(string,"ON")));
}
/* option handlers */
int globoption(long type)
{
	int rv = TRUE;
	switch (type) {
		case OPTCL:                  /* ifstyle = 1 */
			ifstyle = 1;
			break;
		case OPTCRE:		/* xref */
			xrefon(1);
			break;
		case OPTMC:		/* macstyle = 4 */
		case OPTMEX:		/* macstyle = 4 */
			macstyle = 4;
			break;
		case OPTNOCL:		/* ifstyle = 0 */
			ifstyle = 0;
			break;
		case OPTNOMC:		/* macstyle = 0 */
		case OPTNOMEX:		/* macstyle = 0 */
			macstyle = 0;
			break;
		default:
			rv = FALSE;
	}
	return(rv);
}
int globoptequexp(long type, EXPRESSION *exp, EXPRESSION *exp2)
{
	int rv = TRUE;
	switch(type) {
		case OPTEQUIFSTYLE:
			ifstyle = exp->x.value;
			if (ifstyle > 2)
				ifstyle = 0;
			break;
		case OPTEQUINFO:
			break;
		case OPTEQULIST:
			liston((unsigned) exp->x.value);
			break;
		case OPTEQUMACSTYLE:
			macstyle = exp->x.value;
			if (macstyle > 5)
				macstyle = 1;
			break;
		case OPTEQUWARN:
			break;
		case OPTEQUXREF:
			xrefon((unsigned) exp->x.value);
			break;
		default:
			rv = FALSE;
	}
	return(rv);
}
int globoptequstring(long type, char *string)
{
	int rv = TRUE;
	switch(type) {
		case OPTEQUSUBTTL:
			setsubtitle(string);
			break;
		case OPTEQUTITLE:
			setitle(string);
			break;
		case OPTEQULIST:
			liston(checkon(string));
			break;
		case OPTEQUTARGET:
			if (poption(string))
				Error("Bad target type");
			break;
		case OPTEQUXREF:
			xrefon(checkon(string));
			break;
		default:
			rv = FALSE;
	}
	return(rv);
}