%{
#include "utype.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "lexpr.h"
#include "partit.h"
#include "input.h"
%}
%union {
long	value;
char	*name;
LEXPRESSION	*expression;
LDESCRIPTION	*description;
}

%token <value> REGION PARTITION OVERLAY VIRTUAL
%token <value> ADDRESS SIZE ROUNDSIZE NUMBER ALIGN
%token <value> SHRIGHT SHLEFT NUMBER
%token <name> SYMBOL
%type <expression> exp quallist qualifiers
%type <description> partitions partition overlay region

%left ';'
%right '='
%left '|'
%left '^'
%left '&'
%left SHRIGHT SHLEFT
%left '-' '+'
%left '*' '/' '%' SCALE
%left NEG     /* Negation--unary minus */
/* Grammar follows */

%%
input:	/* empty */
	group ';'
;
group:	| PARTITION partitions 			{ AddPartition($2); }
	| SYMBOL '=' exp 			{ AddPartition(MakeSymbol($1,$3)); }
	| group ';' group
;
partitions: '{' partition ';' '}' SYMBOL qualifiers { $$ = MakePartition($2,$5,$6); }
	| '{' '}' SYMBOL qualifiers { $$ = MakePartition(0,$3,$4); }
	| partitions ',' partitions 		{ $$ = MergeList($1, $3); }
;
partition:  SYMBOL '=' exp 			{ $$ = MakeSymbol($1, $3); }
	  | OVERLAY '{' overlay ';' '}' SYMBOL qualifiers { $$ = MakeOverlay($3, $6, $7) ; }
	  | OVERLAY '{' '}' SYMBOL qualifiers { $$ = MakeOverlay(0, $4, $5) ; }
	  | partition ';' partition		{ $$ = MergeList($1, $3); }
;
overlay:   SYMBOL '=' exp			{ $$ = MakeSymbol($1, $3); }
	 | REGION '{' region ';' '}' SYMBOL qualifiers { $$ = MakeRegion($3, $6, $7); }
	 | REGION '{' '}' SYMBOL qualifiers 	{ $$ = MakeRegion(0, $4, $5); }
	 | overlay ';' overlay			{ $$ = MergeList($1, $3); }
;
region:  SYMBOL '=' exp			{ $$ = MakeSymbol($1, $3); }
	 | region ';' region			{ $$ = MergeList($1, $3); }
;
qualifiers: /* empty */		 { $$ = 0; }
	   | '[' quallist ']'    { $$ = $2; }
;
quallist: /* empty */		{ $$ = 0; }
	  | ALIGN '=' exp	{ $$ = AddLinkerAttribs(EXP_ALIGN, $3, 0 ); }
	  | NUMBER '=' exp	{ $$ = AddLinkerAttribs(EXP_NUMBER, $3, 0 ); }
	  | ROUNDSIZE '=' exp   { $$ = AddLinkerAttribs(EXP_ROUNDSIZE, $3, 0 ); }
	  | SIZE '=' exp        { $$ = AddLinkerAttribs(EXP_SIZE, $3, 0 ); }
	  | ADDRESS '=' exp     { $$ = AddLinkerAttribs(EXP_ADDRESS, $3, 0 ); }
	  | VIRTUAL		{ $$ = AddLinkerAttribs(EXP_VIRTUAL,AddLinkerExpression(0,EXP_NUMBER,-1L,0,0),0); }
	  | VIRTUAL '=' exp     { $$ = AddLinkerAttribs(EXP_VIRTUAL,$3,0); }
	  | quallist ',' quallist { $$ = MergeLinkerAttribs($1, $3); }
;
	
		

exp:      NUMBER                { $$ = AddLinkerExpression(0,EXP_NUMBER, $1, 0, 0); }
	| '$'		     { $$ = AddLinkerExpression(0, EXP_PC, 0, 0, 0); }
        | SYMBOL                { $$ = AddLinkerExpression($1, EXP_EXTERN, 0, 0, 0); }
	| exp '|' exp	     { $$ = AddLinkerExpression(0,EXP_OR, 0, $1, $3); }
	| exp '^' exp	     { $$ = AddLinkerExpression(0,EXP_XOR, 0, $1, $3); }
	| exp '&' exp	     { $$ = AddLinkerExpression(0,EXP_AND, 0, $1, $3); }
	| exp SHLEFT exp     { $$ = AddLinkerExpression(0,EXP_SHL, 0, $1, $3); }
	| exp SHRIGHT exp    { $$ = AddLinkerExpression(0,EXP_SHR, 0, $1, $3); }
        | exp '+' exp        { $$ = AddLinkerExpression(0,EXP_PLUS, 0, $1, $3); }
        | exp '-' exp        { $$ = AddLinkerExpression(0,EXP_MINUS, 0, $1, $3); }
        | exp '*' exp        { $$ = AddLinkerExpression(0,EXP_TIMES, 0, $1, $3); }
        | exp '/' exp        { $$ = AddLinkerExpression(0,EXP_DIVIDE, 0, $1, $3); }
        | exp '%' exp        { $$ = AddLinkerExpression(0,EXP_MOD, 0, $1, $3); }
        | '-' exp  %prec NEG { $$ = AddLinkerExpression(0,EXP_NEG, 0, $2, 0); }
	| '~' exp  %prec NEG { $$ = AddLinkerExpression(0,EXP_NOT, 0, $2, 0); }
        | '(' exp ')'        { $$ = AddLinkerExpression(0, EXP_PAREN, 0, $2, 0); }
;
/* End of grammar */
%%