;=====================================================================
; ***** Copyright Issues ***** 
; This program (the source or its binary form) was released in public 
; domain by its original author Vickle Chan Mingwah, and is considered 
; a public domain software, which means any one can freely use, 
; modify, and redistribute it for any purpose as he/she likes. And 
; since the time this program went to public domain, its original 
; author has *NO* responsibility for any consequence of using this 
; program or any of its deriving forms.
; 
; I suggest you keep this copyright note even you modify this program, 
; though it is not required. :-)
; 
; ***** Usage *****
; Compile the source code with Microsoft MASM 5.0 (higher version or 
; other compatible asm compilers might also work), and link it into a
; .COM executable. 
;
; Connect two PCs with a null modem cable, which connecting through 
; RS232 serial ports.  
;
; Run bser.com (the server) and bcli.com (the client) respectively on
; each PC. The supported OSes are DOS 3.3 or higher and WIN9x. There
; are some additional command line arguments available. Refer to
; the source code.
;
; For more details about the program, please refer to the accompanying
; Manual.pdf, which is in Chinese. 
;  
;=====================================================================

;*************************************************
;  backdoor / server       
;  bser.com 
;  Written by Chan Ming Wah 1/14/2000
;*************************************************

cseg    segment
        assume  cs:cseg,ds:cseg
        org 100h
begin:
        jmp     near ptr main

comINT  db      0Bh
intMask db      11110111b
BaseAdd dw      0402h
THR     dw      ?               ;UART registers
RBR     dw      ?
LSB     dw      ?
IER     dw      ?
MSB     dw      ?
IIR     dw      ?
FCR     dw      ?
LCR     dw      ?
MCR     dw      ?
LSR     dw      ?
MSR     dw      ?
org_intCom      dd      ?
org_int21       dd      ?

int_com proc                    ;comport interrupt
        push    dx              ;preserve registers
        push    ax
        push    cx

        mov     dx,cs:RBR
        in      al,dx

        mov     ah,05h
        mov     ch,0
        mov     cl,al
        int     16h

        mov     al,20h          ;end-of-int signal
        out     20h,al

        pop     cx
        pop     ax              ;restore registers
        pop     dx

        iret
int_com endp

int_21  proc                    ;int_21h replacement
        push    ds
        push    si
        push    cx
        push    dx
        push    ax

        cmp     ah,02h
        jz      fun02
        cmp     ah,09h
        jz      fun09
        cmp     ah,40h
        jz      fun40
callorg:
        pop     ax
        pop     dx
        pop     cx
        pop     si
        pop     ds
        jmp     cs:org_int21

fun02:
        mov     al,dl
        call    send
        jmp     callorg
fun09:
        mov     si,dx
  lp1:
        mov     al,[si]
        cmp     al,'$'
        jz      callorg
        call    send
        inc     si
        jmp     lp1

fun40:
        cmp     bx,1            ;output to STDOUT?
        jnz     callorg
        mov     si,dx
  lp2:
        mov     al,[si]
        call    send
        inc     si
        loop    lp2             ;CX was already set
        jmp     callorg

int_21  endp

send    proc
        push    ax
        mov     dx,cs:LSR
  lp3:
        in      al,dx
        test    al,20h          ;ready to send?
        jz      lp3
        pop     ax

        mov     dx,cs:THR
        out     dx,al
        ret
send    endp


main    proc

        mov     ax,cs
        mov     ds,ax

        call    param

        push    ds              ;address definiton

        mov     ax,0            ;now visit the 0000 segment       
        mov     ds,ax

        mov     bx,5feh         ;location of mark            

        cmp     cs:nocheck,0    ;check before instance?
        jnz     mark

        mov     ax,word ptr[bx]
        cmp     ax,'WM'
        jnz     mark
        jmp     exit            ;if marked, exit

mark:
        mov     ax,'WM'         ;put a mark
        mov     [bx],ax

;get_comport_address

        mov     bx,cs:BaseAdd
        mov     ax,[bx]
        pop     ds

        mov     THR,ax
        mov     RBR,ax
        mov     LSB,ax
        inc     ax
        mov     IER,ax
        mov     MSB,ax
        inc     ax
        mov     IIR,ax
        mov     FCR,ax
        inc     ax
        mov     LCR,ax
        inc     ax
        mov     MCR,ax
        inc     ax
        mov     LSR,ax
        inc     ax
        mov     MSR,ax

install_int:
        SetVect macro num,handler
                mov     dx,offset handler
                mov     ah,25h
                mov     al,num
                int     21h
                endm        
        GetVect macro num,handler
                mov     ah,35h
                mov     al,num
                int     21h
                mov     word ptr cs:handler+2,es
                mov     word ptr cs:handler,bx
                endm

        GetVect comINT,org_intCOM
        SetVect comINT,int_com

        GetVect 21h,org_int21
        SetVect 21h,int_21

init:
        cli

        mov     dx,LCR                  ;set communication parameters
        mov     al,10000011b            ;set bit-7, 8N1
        out     dx,al

        mov     dx,LSB                  ;K=0ch, 9600Baud
        mov     al,0ch
        out     dx,al

        mov     dx,MSB
        mov     al,0
        out     dx,al

        mov     dx,LCR
        mov     al,00000011b
        out     dx,al                   ;reset bit-7

        mov     dx,MCR                  ;enable interrupt
        mov     al,00001011b
        out     dx,al

        mov     dx,IER                  ;enable interrupt
        mov     al,00000001b
        out     dx,al

        mov     dx,FCR                  ;clear XMIT & RCVR FIFO
        mov     al,00000111b
        out     dx,al

        in      al,21h                  ;set IntMaskReg
        and     al,intMask
        out     21h,al

        sti

TSR:
        print   macro   msg
                mov     ah,09h
                mov     dx,offset msg
                int     21h
                endm

        print   okay

        mov     dx,offset main          ;calculate program size
        mov     cl,4
        shr     dx,cl
        inc     dx
        mov     ax,3100h                ;Terminate & Stay Remained
        int     21h

exit:
        pop     ds
        print   no_ok

        mov     ax,4c01h
        int     21h

main    endp

param   proc
        mov     bx,0080h        ;visit the PSP
        mov     ch,0
        mov     cl,[bx]
        cmp     cl,0
        jz      return
  lp4:
        inc     bx
        mov     al,[bx]
        cmp     al,'1'
        jz      use_c1
        cmp     al,'2'
        jz      use_c2
        cmp     al,'I'
        jz      set_nocheck
        loop    lp4
  return:
        ret

  use_c1:
        mov     BaseAdd,0400h
        mov     comINT,0Ch
        mov     intMask,11101111b
        jmp     lp4
  use_c2:
        mov     BaseAdd,0402h
        mov     comINT,0Bh
        mov     intMask,11110111b
        jmp     lp4
  set_nocheck:
        mov     nocheck,1
        jmp     lp4

param   endp

nocheck db      0                       ;check before instance?
okay    db      'Ok.',0dh,0ah,'$'
no_ok   db      'cannot install.',0dh,0ah,'$'

cseg    ends
        end     begin


