/*  malloc.h

    memory management functions and variables.

*/

#ifndef __MALLOC_H
#define __MALLOC_H

#ifndef __DEFS_H__
#include <defs.h>
#endif


#define NULL 0

#define _HEAPEMPTY      1
#define _HEAPOK         2
#define _FREEENTRY      3
#define _USEDENTRY      4
#define _HEAPEND        5
#define _HEAPCORRUPT    -1
#define _BADNODE        -2
#define _BADVALUE       -3

#ifndef _STDDEF
#define _STDDEF
#ifndef _PTRDIFF_T
#define _PTRDIFF_T
  typedef int ptrdiff_t;
#endif
#ifndef _SIZE_T
  #define _SIZE_T
  typedef unsigned size_t;
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __CC386__
#define _fmalloc(size) farmalloc(size)
#define _ffree(size)  farfree(size)
#endif

void        _RTL_NORM *calloc(size_t __nitems, size_t __size);
void        _RTL_NORM free(void *__block);
void        _RTL_NORM *malloc(size_t __size);
void        _RTL_NORM *realloc(void *__block, size_t __size);
#ifdef __CC386__
void        _RTL_NORM _FAR *farmalloc(size_t __size) ;
void        _RTL_NORM farfree(void _FAR *__block) ;
#endif

#ifdef __cplusplus
};
#endif

#endif  /* __MALLOC_H */