/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       cos(x));
}
char  feq[] = " cos(x)";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(  (-sin(x)) );
}
char Dfeq[] = " (-sin(x)) ";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

double c = .5;
double t;
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n", feq);
 printf(" Df : x-> %s\n\n",Dfeq);

 printf(" With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );
 printf("\n\n\n\n");
 getchar();

 clrscrn();
 printf(" Find AM, the length of the under tangent.\n\n");

 t =((*Pfunct)(c));
 printf(" P(%6.3lf, %6.3lf)         -> P(c, f(c))         \n", c, t);

 t = c-(((*Pfunct)(c))/((*PfunctDeriv)(c))) ;
 printf(" A(%6.3lf, %6.3lf)         -> A(c-f(c)/Df(c),0)\n",t, 0.);
 printf(" M(%6.3lf, %6.3lf)         -> M(c,0)\n\n", c, 0.);

 t = (((*Pfunct)(c))*(1/((*PfunctDeriv)(c))));
 printf(" AM = %6.3lf               -> f(c)/Df(c)\n\n", t);

                         /* plot [xmin:xmax] [ymin:ymax] */
  gplt_TanxM   (-7,      /* xmin */
                 7,      /* xmax */
                -2,      /* ymin */
                 2,      /* ymax */
                 c,
               feq,
         (*Pfunct),
         (*PfunctDeriv));

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :\n\n");
 printf("     * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

