<?php
#######################
#This contribution is an AskCost.com Store Feed contributions plus for easy install.
#
#It was created as an AskCost.com feed.This module will allow you to list your products on AskCost, one of the top price comparison search engines in the world, 
#by generating a data feed export. this will deliver targeted customers to your online shop store when they are ready to buy, increasing your store sales.
#
#It is now VERY customer friendly.
#
#This contribution has been tested to work in all unmodified and modified versions of oscommerce MS2.2.but it can't use MS3.0 Temporarily.
#
# oscommerce price options - taxes = on,off (default = on); special = on,off (default = on)
# askcost_oscommerce.php?taxes=off
# askcost_oscommerce.php?special=off
# askcost_oscommerce.php?taxes=off&special=off
# askcost_oscommerce.php?add_vat=on
#
# General options
# description = on,off
# image = on,off
# 
#If this script code can't work normallyplease download latest package. 
#If you have any problem, please contact us!  http://www.askcost.com/contact_us.php
#
#// DESCRIPTION
#Creates and automatically sends a data feed to AskCost, to provide product information and pictures.
#// INSTALLATION
#Step 1: Unzip and upload the file AskCost_oscommerce.php to your catalog directory
#Step 2: Join the merchant solutions center.
#Step 3: Set up the path to the datafeed file on the Merchant Product Listings Manager
#Our system will having your products from your server, listed automatically on AskCost.com in 24 hours.


#######################


# If you use a default configuration you need to do place this file in your store /catalog/ directory. 
# Otherwise if you place this file in another directory please modify the line below with the path to the catalog directory. 

$path_catalog = "./";

// Define VAT value
$vat_value = 1.00; // if it's 19%,it's 1.19

# Once all is set up you need to check the result and make sure the output is correct
# Point the browser to http://www.yourstore.com/askcost_oscommerce.php and look into the source code of the out put
# What you need to see is something like this
# code	product_url	name	image_url	price	description	category	manufacturer	model	currency

##### Avoid any modifications below this line #####

// Datafeed specific settings
$datafeed_separator = "\t"; // Possible options are "\t"

// Taxes options - possible values on, off
$applytaxes = ($_GET['taxes'] == "off") ? "off" : "on";
// Special price options - possible values on, off
$applyspecial = ($_GET['special'] == "off") ? "off" : "on";
$showspecialprice = ($_GET['specialprice'] == "off") ? "off" : "on";

// Add VAT to prices
$add_vat = ($_GET['add_vat'] == "on") ? "on" : "off";

// Description options - possible values on, off
$show_description = ($_GET['description'] == "off") ? "off" : "on";
// Image options - possible values on, off
$show_image = ($_GET['image'] == "off") ? "off" : "on";

// Include required files
if(file_exists($path_catalog . "includes/shared.inc.php")) {
	require($path_catalog . "includes/shared.inc.php");
}

if(!file_exists($path_catalog . "includes/application_top.php")) {
	exit('<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY><H1>Not Found</H1>Please ensure that askcost_oscommerce.php is in the catalog directory, or make sure the path to the catalog directory is defined corectly above in $catalog_path variable<br><br>If you have any problem, please contact us!  <a href=http://www.askcost.com/contact_us.php>http://www.askcost.com/contact_us.php</a></BODY></HTML>');
}
else {
	require($path_catalog . "includes/application_top.php");
}

$already_sent = array();

// Detect default currency
$query_currency = tep_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'DEFAULT_CURRENCY'");
$row_currency = tep_db_fetch_array( $query_currency );

// Get default currency value
$query_currency_rate = tep_db_query("SELECT value FROM " . TABLE_CURRENCIES . " WHERE code = '" . addslashes($row_currency['configuration_value']) . "'");
$row_currency_rate = tep_db_fetch_array( $query_currency_rate );

// Detect default language code
$query_language_code = tep_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'DEFAULT_LANGUAGE'");
$row_language_code = tep_db_fetch_array( $query_language_code );

// Detect default language ID
$query_language_id = tep_db_query("SELECT languages_id FROM " . TABLE_LANGUAGES . " WHERE code = '" . $row_language_code['configuration_value'] . "'");
$row_language_id = tep_db_fetch_array( $query_language_id );

// Get all categories
$categories_query = tep_db_query("SELECT * 
FROM (" . TABLE_CATEGORIES . ") 
LEFT JOIN " . TABLE_CATEGORIES_DESCRIPTION . " ON ( " . TABLE_CATEGORIES_DESCRIPTION . ".categories_id = " . TABLE_CATEGORIES . ".categories_id AND " . TABLE_CATEGORIES_DESCRIPTION . ".language_id = '" . $row_language_id['languages_id'] . "')"
);

while( $row_cat = tep_db_fetch_array( $categories_query ) ) {
	foreach ($row_cat as $i=>$v) {
		$CAT_ARR[$row_cat['categories_id']][$i] = $v;
	}
}

// Grab the products
$image_field = ($show_image == "on") ? "prd.products_image" : "''";
$description_field = ($show_description == "on") ? "prdsc.products_description" : "''";

$products_query = tep_db_query("SELECT
manuf.manufacturers_name AS manufacturer,
prd.products_id AS id,
prd.products_id AS mpc,
prd.products_model AS mpn,
prdsc.products_name AS name,
" . $description_field . " AS description,
prd.products_price AS price,
prd.products_tax_class_id,
" . $image_field . " AS products_image,
prdtocat.categories_id

FROM (" . TABLE_PRODUCTS . " prd,
" . TABLE_PRODUCTS_DESCRIPTION . " AS prdsc,
" . TABLE_PRODUCTS_TO_CATEGORIES . " AS prdtocat)
LEFT JOIN " . TABLE_MANUFACTURERS . " AS manuf ON ( manuf.manufacturers_id = prd.manufacturers_id )
WHERE 
( prd.products_id = prdsc.products_id AND prdsc.language_id = '" . $row_language_id['languages_id'] . "' )
AND prd.products_id = prdtocat.products_id
AND prd.products_status = 1 
ORDER BY prdtocat.categories_id DESC
LIMIT 10000");

// Check for any applicable specials for the corresponding products_id
$specials_query = tep_db_query("SELECT
" . TABLE_SPECIALS . ".products_id AS idS,
" . TABLE_SPECIALS . ".specials_new_products_price AS priceS
FROM
" . TABLE_SPECIALS . ",
" . TABLE_PRODUCTS . "
WHERE
" . TABLE_SPECIALS . ".products_id = " . TABLE_PRODUCTS . ".products_id
AND " . TABLE_SPECIALS . ".status = 1 
AND " . TABLE_PRODUCTS . ".products_status = 1");

while( $row_s = tep_db_fetch_array( $specials_query ) ) {
	foreach ($row_s as $i=>$v) {
		$SPECIALS[$row_s['idS']][$i] = $v;
	}
}
// Print products column
print 
	'code' . $datafeed_separator .
	'product_url' . $datafeed_separator .
	'name' . $datafeed_separator .
	'image_url' . $datafeed_separator .
	'price' . $datafeed_separator .
	'description' . $datafeed_separator .
	'category' . $datafeed_separator .
	'manufacturer' . $datafeed_separator .
	'model' . $datafeed_separator .
	'currency' .
	"\n";
// Print the products
while( $row = tep_db_fetch_array( $products_query ) )
{
	// If we've sent this one, skip the rest - this is to ensure that we do not get duplicate products
	if ($already_sent[$row['mpc']] == 1) continue;
	
	// Clean description
	$row['description'] = clean_description($row['description']);
	
	$row['product_url'] = tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $row['id'], 'NONSSL', false);
	
	if($row['products_image'] != "") {
		
		if (preg_match("/http\:\/\//", $row['products_image'])) {
			$row['image_url'] = $row['products_image'];
		}
		elseif (preg_match("/http\:\/\//", DIR_WS_IMAGES)) {
			$row['image_url'] = DIR_WS_IMAGES . $row['products_image'];
		}
		elseif (preg_match("/http\:\/\//", DIR_WS_CATALOG)) {
			$row['image_url'] = DIR_WS_CATALOG . DIR_WS_IMAGES . $row['products_image'];
		}
		else {
			$row['image_url'] = HTTP_SERVER . DIR_WS_CATALOG . DIR_WS_IMAGES . $row['products_image'];
		}		
	}
	else {
		$row['image_url'] = "";
	}
	
	// Reset the products price to our special price if there is one for this product
	if (($showspecialprice == "on") && ($new_price = tep_get_products_special_price($row['id']))) {
		$row['price'] = $new_price;
	}
	elseif(($applyspecial == "on") && $SPECIALS[$row['id']]['idS']){
		$row['price'] = $SPECIALS[$row['id']]['priceS'];
	}
	
	// Include tax - if this is not working corectly simply comment the following lines and you will have the prices without the tax included
	if ( $applytaxes == "on" && (DISPLAY_PRICE_WITH_TAX == "true") && ($row['products_tax_class_id'] > 0) ) {
		$row['price'] = $row['price'] + ( ( $row['price'] * tep_get_tax_rate($row['products_tax_class_id']) ) / 100 );
    }
	
	// $row['price'] = tep_add_tax($row['price'], tep_get_tax_rate($row['products_tax_class_id'])); // Slower method for tax calculation
    
	// Clean product name (new lines)	
	$row['name'] = str_replace("\n", " ", strip_tags($row['name']));		
	$row['name'] = str_replace("\r", "", strip_tags($row['name']));
	$row['name'] = str_replace("\t", " ", strip_tags($row['name']));
	
	// Clean product description (Replace new line with <BR>). In order to make sure the code does not contains other HTML code it might be a good ideea to strip_tags()	
    //$row['description'] = str_replace("\n", "<BR>", $row['description']);
	$row['description'] = replace_not_in_tags("\n", "<BR />", $row['description']);
	$row['description'] = str_replace("\n", " ", $row['description']);
	$row['description'] = str_replace("\r", "", $row['description']);
	$row['description'] = str_replace("\t", " ", $row['description']);
	
	// Clean product names and descriptions (separators)
	if ($datafeed_separator == "\t") {
		// Continue... tabs were already removed
	}
	elseif ($datafeed_separator == "|") {
		$row['name'] = str_replace("|", " ", strip_tags($row['name']));
		$row['description'] = str_replace("|", " ", $row['description']);
	}
	else {
		print "Incorrect columns separator.";
		exit;			
	}
	
	// Get category name
	$category_name = get_full_cat($row['categories_id'], $CAT_ARR);
	
	// Add VAT to prices
	if ($add_vat == "on") {
		$row['price'] = $row['price'] * $vat_value;
	}
	
	// Apply currency exchange rates
	$row['price'] = number_format($row_currency_rate['value'] * $row['price'], 2);
	
	// Output the datafeed content
	//code	product_url	name	image_url	price	description	category	manufacturer	model	currency
	print 
		$row['mpc'] . $datafeed_separator .
		$row['product_url'] . $datafeed_separator .
		$row['name'] . $datafeed_separator .
		$row['image_url'] . $datafeed_separator .
		$row['price'] . $datafeed_separator .
		$row['description'] . $datafeed_separator .
		$category_name . $datafeed_separator .
		$row['manufacturer'] . $datafeed_separator .
		$row['mpn'] . $datafeed_separator .
		$row_currency['configuration_value'] .
		"\n";
	
	$already_sent[$row['mpc']] = 1;
}

// Function to get category with full path
function get_full_cat($cat_id, $CATEGORY_ARR) {

	$item_arr = $CATEGORY_ARR[$cat_id];
	$cat_name = $item_arr['categories_name'];
	
	while (sizeof($CATEGORY_ARR[$item_arr['parent_id']]) > 0 && is_array($CATEGORY_ARR[$item_arr['parent_id']]) ) {
		
		$cat_name = $CATEGORY_ARR[$item_arr['parent_id']]['categories_name'] . " > " . $cat_name;		
		$item_arr = $CATEGORY_ARR[$item_arr['parent_id']];
	}
	
	// Strip html from category name
	$cat_name = html_to_text($cat_name);
	
	return $cat_name;
}

function html_to_text($string){

	$search = array (
		"'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",  // Strip out html tags
		"'([\r\n])[\s]+'",  // Strip out white space
		"'&(quot|#34);'i",  // Replace html entities
		"'&(amp|#38);'i",
		"'&(lt|#60);'i",
		"'&(gt|#62);'i",
		"'&(nbsp|#160);'i",
		"'&(iexcl|#161);'i",
		"'&(cent|#162);'i",
		"'&(pound|#163);'i",
		"'&(copy|#169);'i",
		"'&(reg|#174);'i",
		"'&#8482;'i",
		"'&#149;'i",
		"'&#151;'i",
		"'&#(\d+);'e"
		);  // evaluate as php
	
	$replace = array (
		" ",
		" ",
		"\\1",
		"\"",
		"&",
		"<",
		">",
		" ",
		"&iexcl;",
		"&cent;",
		"&pound;",
		"&copy;",
		"&reg;",
		"<sup><small>TM</small></sup>",
		"&bull;",
		"-",
		"uchr(\\1)"
		);
	
	$text = preg_replace ($search, $replace, $string);
	return $text;
	
}

function clean_description($string){

	$search = array (
		"'<html>'i",
		"'</html>'i",
		"'<body>'i",
		"'</body>'i",
		"'<head>.*?</head>'si",
		"'<!DOCTYPE[^>]*?>'si"
		); 
		
	$replace = array (
		"",
		"",
		"",
		"",
		"",
		""
		); 
		
	$text = preg_replace ($search, $replace, $string);
	return $text;

}

function replace_not_in_tags($find_str, $replace_str, $string) {
	
	$find = array($find_str);
	$replace = array($replace_str);	
	preg_match_all('#[^>]+(?=<)|[^>]+$#', $string, $matches, PREG_SET_ORDER);	
	foreach ($matches as $val) {	
		if (trim($val[0]) != "") {
			$string = str_replace($val[0], str_replace($find, $replace, $val[0]), $string);
		}
	}	
	return $string;
}

exit;

?>