/* vp.h */


#define	OKAY		0
#define	NOT_OKAY	(-1)
#ifndef	TRUE
#define	TRUE		1
#define	FALSE		0
#endif
#define	MAX_STRLEN		80

/* 
  Plotting Primitives 
*/
void move_abs();
void move_rel();
void point();
void cont();
void vect();
void label();
void erase();
void finish();
void set_color();
void linemod();
void set_unixplot_window(/* int, int */);

void window_origin_set();
void window_size_set();
void canvas_size_set();
void window_label_set(/* char * */);

#define	CHAR_HEIGHT	16
#define	CHAR_WIDTH	9

/* debug */
/*
 *	various macros 
 *	for debugging and error trapping 
 *	of xyview routines
 */

#ifndef DEBUG
#define DEBUG 0
#endif

#define DBPRINTF 	if (DEBUG) printf
#define DBFPRINTF 	if (DEBUG) fprintf

#define fatal(str)			debug_message("Fatal","%s",str), exit(-1)
#define fatal_arg(fmt,ag)	debug_message("Fatal",fmt,ag), exit(-1)
#define	danger(str)			debug_message("Danger","%s",str)
#define danger_arg(fmt,ag)	debug_message("Danger",fmt,ag)

static void 
debug_message(serious,fmt,arg)
char *serious;
char *fmt;
char *arg;
{
    (void)fprintf(stderr, "%s: ", serious );
    (void)fprintf(stderr, fmt,  arg );
    (void)fprintf(stderr, "\n");
}

