		/* converts xylang to plot(5)  */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "xyplot.h"

int eraseQ = NO;  /* erases first */
int resetQ = NO;  /* resets origin after finishing */
int linewQ = NO;  /* output protocol for linewidths */

main(ac,av)
int ac;
char *av[];
{
	char in[512],text[256],gstr[30];
	int i,x,y,x1,x2,y1,y2,c;
	float size;

	while (--ac)
	{
		if (av[ac][0]=='-' && av[ac][1]=='e')   /* erase first */
			eraseQ = YES;
		else if (av[ac][0]=='-' && av[ac][1]=='w')   /* lineWidth protocol */
			linewQ = YES;
		else {
			fprintf(stderr,"Usage:  %s [-e] [-w]\n",av[0]);
			exit(-1);
		}
	}


	i=0;
	if(eraseQ) erase();
	while((c=fgetc(stdin))!=EOF) {	
		in[i++]=c;
		while((c=fgetc(stdin))!=EOF && c!='\n') in[i++]=c;
		in[i]='\0';

		resetQ = YES;	/* if the program never gets here, then
						 * there is nothing to reset.  it is better
						 * in that case, if nothing is output at all
						 */

		switch (in[0]) {
		   case 'm' : 	sscanf(in,"%*s %d %d",&x,&y);
				move(x,y);
				break;
		   case 'p' : 	sscanf(in,"%*s %d %d",&x,&y);
				point(x,y);
				break;
		   case 'l' :	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				line(x1,y1,x2,y2);
				break;
		   case 'n' : 	sscanf(in,"%*s %d %d",&x,&y);
				cont(x,y);
				break;
		   case 's' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				space(x1,y1,x2,y2);
				break;
		   case 't' :	sscanf(in,"%*s %1s",&x);
				label(x);
				break;
		   case 'f' :	sscanf(in,"%*s %s",text);
				linemod(text);
				break;
		   case 'e' :	if(!eraseQ) erase();
				break;
		   case 'a' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				unix_to_ugs(text);
			    x += 30*size; /* moves text over to the right
                               * so that left edge (not center)
							   * of first letter matches x value
							   */
				ascii(text,x,y,size);
				break;
		   case 'r' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
		   		strcpy(text,in+c+1); 
				if(isreal(text)) {
					g_to_ugs(text,gstr);
					rascii(gstr,x,y,size);
				} else {
					unix_to_ugs(text);
					rascii(text,x,y,size);
				}
				break;
		   case 'c' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				if(isreal(text)) {
					g_to_ugs(text,gstr);
					cascii(gstr,x,y,size);
				} else {
					unix_to_ugs(text);
					cascii(text,x,y,size);
				}
				break;
		   case 'v' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				unix_to_ugs(text);
				cvascii(text,x,y,size);
				break;
		   case 'w' :
			   if (linewQ) /* this is nonstandard protocol! */
			   {
				   float width;
				   sscanf(in,"%*s %f",&width);
				   putchar('w');
				   putcoord((int)width);
			   }
			   break; 
			   
		   case 'b' :   break; /* don't use bounding box */
		   default  : 	fprintf(stderr,"Unexpected command\n");
				fprintf(stderr,"%s\n",in);
				exit(2);
				break;
		}
		i=0;
	}
	if (resetQ) 
		move(0,0);
}

isreal(t)
char *t;
{
	char ms[30],es[6],c,*ti;
	int exp,expresent;
	double mant;

	expresent=NO;

	/* store initial string pointer */
	ti = t;

	/* almost parse a real number */

	/* leading space is okay */
	while( *t != '\0' && isspace(*t) ) ++t;   /* skip white space */

	/* leading character better be a digit, sign, or decimal point */
    if   ( *t != '\0' && (isdigit(*t) || *t=='+' || *t=='-' || *t=='.') ) 
		++t;
	else
		return NO;

	while( *t != '\0' && isdigit(*t) ) ++t;
	while( *t != '\0' && ( *t=='.' ) ) ++t;
	while( *t != '\0' && isdigit(*t) ) ++t;

	/* saved what has been parsed */
	c=*t; *t='\0';
	strcpy(ms,ti);
	*t=c;

	/* check for exponent */
	if (*t=='e' || *t=='E' )
	{
		++t;
		/* first char after 'e' better be a digit or sign */
		if   ( *t == '\0' || !(isdigit(*t) || *t=='+' || *t=='-' ) ) 
			return NO;
		else
		{
			expresent = YES;
			strcpy(es,t);  /* save it */
			++t;
			while( *t != '\0' && isdigit(*t) ) ++t;
		}
	}

	
	/* trailing space is okay */
	while( *t != '\0' && isspace(*t) ) ++t; 

	/* if made it to the end then its a real */
	if (*t=='\0') {
		if (expresent) {
			sscanf(es,"%d",&exp);
			sprintf(es,"%-d",exp);
			sscanf(ms,"%lf",&mant);
#if 1 /* do we really want to "rewrite" the number? */
			sprintf(ti,"%se%s",ms,es);
#endif
		}
		return(YES);
	} else {
		return(NO);
	}
}

float	x[2000],y[2000];
int ntext,nsize=2000,npts,bbits[2000];


ascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* right justified string */
rascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;
	float xmax = -(float)(VERYBIG);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++) xmax=(xmax>x[i])?xmax:x[i];
	xorg -= z*xmax;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* centered text */
cascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;
	float xmin = (float)(VERYBIG);
	float xmax = -(float)(VERYBIG);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++){
		xmin=(xmin<x[i])?xmin:x[i];
		xmax=(xmax>x[i])?xmax:x[i];
	}
	xorg -= z*(xmax+xmin)/2.;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* centered vertical text */
cvascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z,temp;
	float ymin = (float)(VERYBIG);
	float ymax = -(float)(VERYBIG);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++){
		temp = y[i];
		y[i] = x[i];
		x[i] = -temp;
		ymin=(ymin<y[i])?ymin:y[i];
		ymax=(ymax>y[i])?ymax:y[i];
	}
	yorg -= z*(ymax+ymin)/2.;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}
