		/* converts xylang to plot(5)  */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "patchlevel.h"
#define YES 	1
#define NO	0 

int eraseQ;	/* erases first */
int tekQ;	/* send xterm tektronik codes */
char *ProgName;

main(ac,av)
int ac;
char *av[];
{
	char in[512],text[256],gstr[30];
	int i,x,y,x1,x2,y1,y2,c;
	float size;
	FILE *f;

	readopts(ac,av);

	i=0;
	if(eraseQ) erase();
	if(tekQ) {
		f = fopen("/dev/tty","w");
		if (f == NULL ) {
		   fprintf(stderr,"%s: Can not open /dev/tyy \n",ProgName);
		   exit(5);
		}
		fprintf(f,"%c[?38h",'\033');
		fflush(f);
	}
	while((c=fgetc(stdin))!=EOF) {	
		in[i++]=c;
		while((c=fgetc(stdin))!=EOF && c!='\n') in[i++]=c;
		in[i]='\0';

		switch (in[0]) {
		   case 'm' : 	sscanf(in,"%*s %d %d",&x,&y);
				move(x,y);
				break;
		   case 'p' : 	sscanf(in,"%*s %d %d",&x,&y);
				point(x,y);
				break;
		   case 'l' :	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				line(x1,y1,x2,y2);
				break;
		   case 'n' : 	sscanf(in,"%*s %d %d",&x,&y);
				cont(x,y);
				break;
		   case 's' : 	sscanf(in,"%*s %d %d %d %d",&x1,&y1,&x2,&y2);
				space(x1,y1,x2,y2);
				break;
		   case 't' :	sscanf(in,"%*s %1s",&x);
				label(x);
				break;
		   case 'f' :	sscanf(in,"%*s %s",text);
				linemod(text);
				break;
		   case 'e' :	if(!eraseQ) erase();
				break;
		   case 'a' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				unix_to_ugs(text);
				ascii(text,x,y,size);
				break;
		   case 'r' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
		   		strcpy(text,in+c+1); 
				unix_to_ugs(text);
				rascii(text,x,y,size);
				break;
		   case 'i' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				g_to_ugs(text,gstr);
				cascii(gstr,x,y,size);
				break;
		   case 'c' :	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				unix_to_ugs(text);
				cascii(text,x,y,size);
				break;
		   case 'v' : 	sscanf(in,"%*s %d %d %f %n",&x,&y,&size,&c);
				strcpy(text,in+c+1);
				unix_to_ugs(text);
				cvascii(text,x,y,size);
				break;
		   case 'w' :	break; /* can't handle linewidths */
		   case 'b' :   break; /* don't use bounding box */
		   default  : 	fprintf(stderr,"Unexpexted command\n");
				fprintf(stderr,"%s\n",in);
				exit(2);
				break;
		}
		i=0;
	}
	move(0,0);

	if (tekQ) {
		fflush(f);
		fprintf(f,"%c%c",'\033','\003');
		fclose(f);
	}
	

}

float	x[2000],y[2000];
int ntext,nsize=2000,npts,bbits[2000];


ascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* right justified string */
rascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;
	float xmax = -(float)(HUGE);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++) xmax=(xmax>x[i])?xmax:x[i];
	xorg -= z*xmax;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* centered text */
cascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z;
	float xmin = (float)(HUGE);
	float xmax = -(float)(HUGE);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++){
		xmin=(xmin<x[i])?xmin:x[i];
		xmax=(xmax>x[i])?xmax:x[i];
	}
	xorg -= z*(xmax+xmin)/2.;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}

/* centered vertical text */
cvascii(ptext,xorg,yorg,size) char* ptext; int xorg,yorg;float size;
{
	int i;
	char c;
	float z,temp;
	float ymin = (float)(HUGE);
	float ymax = -(float)(HUGE);

	z=size;
	i=0;
	while( ptext[i]!='\n' && ptext[i]!='\0')i++;
	ptext[i] = '\0';
	npts = strokes(ptext,x,y,bbits);
	for(i=0;i<npts;i++){
		temp = y[i];
		y[i] = x[i];
		x[i] = -temp;
		ymin=(ymin<y[i])?ymin:y[i];
		ymax=(ymax>y[i])?ymax:y[i];
	}
	yorg -= z*(ymax+ymin)/2.;

	for(i=0;i<npts;i++) {
		if( bbits[i]==0) move(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
		else cont(xorg+(int)(z*x[i]),yorg+(int)(z*y[i]));
	}
}


readopts(ac,av)
int ac;
char *av[];
{
	extern int eraseQ;
	extern int optind;
	extern char *ProgNam;
	extern char *optarg;

	int c;

	/* defaults */
	eraseQ = NO;
	tekQ = NO;
	ProgName = av[0];

	/* scan options */
	while( (c=getopt(ac,av,"?et")) != EOF ) {
	  switch (c) {
		case 'e' :  eraseQ = ! eraseQ;
			    break;
		case 't' :  tekQ = YES;
			    eraseQ = YES;
			    break;
		case '?' :  fprintf(stderr,"scanner  patchlevel %-d\n",
						PATCHED);
			    exit(1);
			    break;
		default  :  fprintf(stderr,"%s: Unknown option %c\n",
				ProgName,c);
			    exit(-1);
			    break;
	  }
	}
}
