/*
 * File :       vwstubs.h
 *
 * Purpose :    RPC Stubs for Hyper-G Viewers
 *
 * Created :    12 Jun 92    Keith Andrews, IICM
 *
 * Modified :   05 Nov 92    Keith Andrews, IICM
 * Modified :   Jul 29		 Peter Pichler, IICM: includes vwstuff.h instead
 *												  of viewer.h ...
 *
 */

#ifndef vwstubs_h
#define vwstubs_h

//PP: #include "viewer.h"
#include "vwstuff.h"

#include <hyperg/Dispatch/rpcwriter.h>
#include <hyperg/Dispatch/rpcreader.h>



// ports where Hyper-G Viewer Daemons listen

const int hg2dvd_port    = 4104 ;                   // Hyper-G 2D Viewer Daemon
const int hg3dvd_port    = 4105 ;                   // Hyper-G 3D Viewer Daemon
const int hgtextvd_port  = 4106 ;                   // Hyper-G Text Viewer Daemon
const int hgimagevd_port = 4107 ;                   // Hyper-G Image Viewer Daemon



//
// class HgViewer_front
//
// Viewer front end.
//

class HgViewer_front : public HgViewer, public RpcWriter
{
public:
  HgViewer_front(                                // constructor
    const char* host,                            //   host name of remote machine
    int port                                     //   port number to use for daemon
  ) ;

  ~HgViewer_front() ;


  virtual void load(                             // load document
    const char* doc,                             //   document
    const char* anchors                          //   source anchors
  ) ;


  virtual void browse(                           // browse current document
    const char* dest = 0                         //   optional destination anchor
  ) ;


  virtual void terminate() ;                     // terminate viewer
} ;







//
// class HgViewer_back
//
// Viewer back end.
//


class RpcHdr ;
class rpcstream ;


class HgViewer_back : public HgViewer, public RpcReader
{
public:
  HgViewer_back( int fd ) ;
  virtual ~HgViewer_back() {} ;

  void run() ;
  void quitRunning() ;


protected:
  virtual void connectionClosed( int ) ;


  // abstract functions implemented by derived viewers

  virtual void load(                             // load document
    const char* doc,                             //   document
    const char* anchors                          //   source anchors
  ) = 0 ;


  virtual void browse(                           // browse current document
    const char* dest = 0                         //   optional destination anchor
  ) = 0 ;

  virtual void terminate() = 0 ;                 // terminate viewer


private:
  int _running ;                                 // am I running my dispatch loop?

  // functions in RPC lookup table
  static void receive_load( RpcReader*, RpcHdr&, rpcstream& ) ;
  static void receive_browse( RpcReader*, RpcHdr&, rpcstream& ) ;
  static void receive_terminate( RpcReader*, RpcHdr&, rpcstream& ) ;
} ;



inline void HgViewer_back::quitRunning()
{
  _running = 0 ;
}

inline void HgViewer_back::connectionClosed( int )
{
  quitRunning() ;
}

#endif


