/*
 * bumpy shader - simulates an bumpy surfaces using noise and Dnoise
 */

#include <math.h>
#include <stdio.h>

#include "sipp.h"
#include "geometric.h"
#include "noise.h"
#include "shaders.h"


extern bool noise_ready;


void
bumpy_shader(nx, ny, nz, u, v, w, view_vec, lights, bd, color)
    double        nx, ny, nz;
    double        u, v, w;
    Vector        view_vec;
    Lightsource  *lights;
    Bumpy_desc   *bd;
    Color        *color;
{
    Vector     tmp;
    double     len;
    double     no;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * bd->scale;
    tmp.y = v * bd->scale;
    tmp.z = w * bd->scale;

    if ((bd->bumpflag && bd->holeflag)
          || ((no = noise(&tmp)) < 0.0 && bd->bumpflag)
          || (no > 0.0 && bd->holeflag)) {
        tmp = Dnoise(&tmp);
        len = sqrt(nx * nx + ny * ny + nz * nz);
        nx = nx / len + tmp.x;
        ny = ny / len + tmp.y;
        nz = nz / len + tmp.z;
    }

    bd->shader(nx, ny, nz, u, v, w, view_vec, lights, bd->surface, color);
}
