# include <sys/types.h>

# include <stdio.h>

# include "getopt.h"

# define CMAP_SIZE	256

struct color_opts {
	char	*col_opt;
	double	*col_val;
	int	col_set;
};

double	bhue =		0;
double	bsat =		0;
double	bbright =	0;
double	ehue =		1;
double	esat =		1;
double	ebright =	1;

static struct color_opts color_opts[] = {
	{ "bhue",	&bhue,		0 },
	{ "bsat",	&bsat,		0 },
	{ "bbright",	&bbright,	0 },
	{ "ehue",	&ehue,		0 },
	{ "esat",	&esat,		0 },
	{ "ebright",	&ebright,	0 },
	{ 0,		0,		0 }
};

static struct option lopts[] = {
	{ "bhue",	1, 0, 0 },
	{ "bsat",	1, 0, 0 },
	{ "bbright",	1, 0, 0 },
	{ "ehue",	1, 0, 0 },
	{ "esat",	1, 0, 0 },
	{ "ebright",	1, 0, 0 },
	{ 0,		0, 0, 0 }
};

int		option_index;
struct option	*_getopt_long_options;

main(argc, argv)
	int		argc;
	char		**argv;
{
	extern double	atof();
	u_char		red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];
	int		lines;
	int		n, i;

	option_index = 0;
	while ((n = getopt_long(argc, argv, "", lopts, &option_index)) != EOF) {
		/*fprintf(stderr, "option = %s, optarg = %s\n",
			lopts[option_index].name, optarg);*/

		for (i = 0; color_opts[i].col_opt != NULL; i++) {
			if (strcmp(color_opts[i].col_opt, lopts[option_index].name) == 0) {
				*color_opts[i].col_val = atof(optarg);
				check(*color_opts[i].col_val);
				break;
			}
		}
	}

	HSBramp(bhue, bsat, bbright, ehue, esat, ebright, 0, 255,
		red, green, blue);

	for (lines = 0; lines < 256; lines++) {
		printf("%d\t%d\t%d\n", red[lines], green[lines], blue[lines]);
		fflush(stdout);
	}

	exit(0);
}

check(num)
	double	num;
{
	if (num < 0.0) {
		fprintf(stderr, "begin/end must be greater than or equal to 0\n");
		usage();
	}

	if (num > 1.0) {
		fprintf(stderr, "begin/end must be less than or equal to 1\n");
		usage();
	}
}

usage() {
	fprintf(stderr, "usage: rampmap [+bhue #] [+bsat #] [+bbright #]\n\
            [+ehue #] [+esat #] [+ebright #]\n\
            (where # must be between 1 and 256)\n");
	exit(1);
}
