/* points.c - GUI for point-repulsion simulation
 *
 * $Id: points.c,v 1.4 96/02/11 21:32:21 leech Exp $
 *
 * Copyright (C) 1996, Jonathan P. Leech
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is". Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	points.c,v $
 * Revision 1.4  96/02/11  21:32:21  leech
 * Totally rewritten from InterViews to a Tcl/Tk wrapper.
 * 
 * Revision 1.2  92/10/27  22:52:31  leech
 * Update for IV 3.1.
 *
 * Revision 1.1  1992/04/27  04:25:13  leech
 * Initial revision
 *
 */

#include <tcl.h>
#include <tk.h>
#include <math.h>
#include <string.h>

#include "Interface.h"
#include "dvector.h"

#include <stdlib.h>
#include <string.h>
#include <stream.h>
#include <math.h>

// Error handler for Vector library
void bad_dvec(int code, const char *msg) {
    cerr << "dvector: error " << code << ": "
	 << msg << endl;
}

// Breakpoint for debugger
void stophere() {
}

// Error handler for math library; atan2(0,0) is not considered an error.
extern "C" int matherr(struct exception *exc) {
    switch (exc->type) {
	case DOMAIN:
	    if (!strcmp(exc->name, "atan2"))
		return 1;
	    else {
		stophere();
		return 0;
	    }
	    break;
	case TLOSS:
	    stophere();
	    return 0;
	default:
	    return 0;
    }
}

// Ensure Tcl version of matherr() is used when linking against
//  shared libraries. Only define if matherr is used on this system.
// #if defined(DOMAIN) && defined(SING)
// extern "C" int matherr(struct exception *);
// int (*tclDummyMathPtr)(struct exception *) = &matherr;
// #endif

int tkAppInit(Tcl_Interp *interp);

// Externs in cmd.o
extern int cmd_Init(Tcl_Interp *interp);

#include <itcl.h>

// tkAppInit - call initialization procedures for all packages,
//  including TkX/Tk.
int tkAppInit(Tcl_Interp *interp)
{
    if (Tcl_Init (interp) == TCL_ERROR) // Tcl commands
	return TCL_ERROR;
    if (cmd_Init(interp) == TCL_ERROR)	// application commands
	return TCL_ERROR;

#ifndef NOITCL
    if (Itcl_Init(interp) == TCL_ERROR) // [incr Tcl]
	return TCL_ERROR;
#endif

#ifndef NOTK
    if (Tk_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
#endif

    return TCL_OK;
}

int main(int ac, char *av[])
{
    // Allow breaking on normalization problems, etc.
    dvector::setErrorHandler(&bad_dvec);

#ifndef NOTK
    Tk_Main(ac, av, &tkAppInit);
#else
    Tcl_Main(ac, av, &tkAppInit);
#endif
    return 0;
}
