/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/vcrDub/RCS/vcrDub.h,v 0.12 91/09/24 22:18:44 lim Exp Locker: drapeau $ */
/* $Log:	vcrDub.h,v $
 * Revision 0.12  91/09/24  22:18:44  lim
 * Changed 'DubEdit' to 'vcrDub' everywhere.
 * Used relative filenames.
 * 
 * Revision 0.11  91/08/25  16:21:18  lim
 * Included diagMode and PrintDiagnostics().
 * 
 * Revision 0.10  91/08/19  16:24:11  lim
 * Initial revision.
 * This version only supports NEC players.
 *  */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "vcrDub_ui.h"
#include <Browse.h>
#include <getopt.h>
#include <videoObj.h>
#include <PlayerStatus.h>

#define MaxNameLength 30
#define MaxPathLength 256
#define MaxListSize 1000
#define MaxLabelSize 22

#define EditHeight 14
#define EditWidth  300
#define EditGap    5
#define LeftMargin 15
#define TopMargin  5
#define AudioXOffset 2
#define AudioYOffset 1
#define LabelXOffset 25
#define LabelYOffset 11

#define Grey84     	0					    /* Color definitions used in the canvas colormaps */
#define Grey92     	1
#define Grey65     	2
#define White      	3
#define Red	    	4
#define Unused1    	5
#define Unused2    	6
#define Black      	7
#define NumColors  	8

#define audioBitmap_width 15					    /* audio dubbing on image */
#define audioBitmap_height 12
static char audioBitmap_bits[] = {
   0xe0, 0x03, 0x10, 0x04, 0x0c, 0x18, 0x02, 0x20, 0x02, 0x20, 0x01, 0x40,
   0x01, 0x40, 0x1d, 0x5c, 0x1d, 0x5c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c};

enum SelectMode { Unselected, Selected };
enum Boolean diagMode;

typedef struct _MergeEdit
{
  char startAddress[12];
  char endAddress[12];
  struct _MergeEdit* nextMergeEdit;
} MergeEdit;

typedef struct _EditLink
{
  struct _EditLink* nextEdit;
  struct _EditLink* prevEdit;
  int origNum;
  enum Boolean audioDub;
  MergeEdit* mergeList;
  enum SelectMode sMode;
} EditLink;

typedef struct _CanvasData
{
  Xv_window paintWindow;					    
  Window    drawable;
  Display*  display;
  GC gc;							    /* Normal GC */
  GC gcXor;							    /* GC which draws with XOR function */
  Cms cms;							    /* Color map segment */
  unsigned long* pixelTable;					    /* Array of pixel values for RGB array of colors */
  EditLink* listHead;						    /* Head of linked list in canvas */
  EditLink* listTail;						    /* Tail of linked list in canvas */
  int numInLinkedList;						    /* Number of edits in linked list */
  int numInMergedLists;						    /* Number of edits in all merged lists */
  int numMerged;						    /* Number of edits from numInLinkedList that are merged */
  int firstSelected;						    /* First selected edit - from 1 to n */
} CanvasData;

CanvasData* editCanvas;

/* Xview stuff */
vcrDub_window1_objects	*vcrDub_window1;
vcrDub_dubSetupWindow_objects	*vcrDub_dubSetupWindow;

void CreateBrowse();
int OpenHandler();
int SaveHandler();
VideoObject* DevInit();
void DisplayError();
void PrintDiagnostics();

static char hrcsid[] = "$Header: /Source/Media/collab/vcrDub/RCS/vcrDub.h,v 0.12 91/09/24 22:18:44 lim Exp Locker: drapeau $";
