/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/messages.c,v 2.12 92/05/29 12:37:50 drapeau Exp $ */
/* $Log:	messages.c,v $
 * Revision 2.12  92/05/29  12:37:50  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 2.11  92/05/14  16:40:19  drapeau
 * Minor change in GetAppIcon() to reflect new location of the program icon.
 * 
 * Revision 2.10  92/01/03  17:50:40  drapeau
 * Changed all calls to Browse() to use "0" instead of "NULL", taking into
 * account the ANSI-C definition of NULL as (void*)0.
 * 
 * Revision 2.0  91/10/06  21:01:43  chua
 * Update to version 2.0
 * 
 * Revision 1.74  91/09/24  16:31:34  chua
 * In GetSelection, obtain the duration and label from the duration and label arrays,
 * instead of from the text fields in the edit panel.
 * 
 * Revision 1.73  91/09/18  17:26:55  chua
 * Removed the hard path for the include files.
 * 
 * Revision 1.72  91/09/16  14:21:28  chua
 * In OpenDoc, do not set cdfilename to the filename passed yet.  This will be done in the
 * OpenHandler if there are no errors in opening the file.
 * 
 * Revision 1.71  91/09/03  15:15:35  chua
 * Added the copyright header.
 * 
 * In OpenDoc, it is no longer necessary to check if the filename is "untitled", since
 * the TimeLine will not pass this value back.
 * 
 * In GetDoc, simply return the name of the current file been edited (there is a variable,
 * cdfilename, which keeps track of this filename).
 * 
 * Added a new function, GetAppIcon, which will return the icon bits of the cdEdit icon
 * to the calling application.
 * 
 * Revision 1.7  91/08/19  19:22:47  chua
 * In GetSelection, set duration = -1 if there is no currently selected edit.
 * 
 * Revision 1.6  91/08/19  14:53:37  chua
 * Made a change in GetSelection to make sure that select.start = -1 if
 * there is no edit selected.
 * 
 * Revision 1.5  91/08/19  14:37:14  chua
 * In GetDoc, return 'untitled' if there is no filename specified.
 * Apparently, the network does not accept NULL as a return value.
 * 
 * In GetSelection, return selection.start = -1 if there is no selection
 * specified.
 * 
 * Revision 1.4  91/08/19  13:59:46  chua
 * In GetDoc, return NULL if there is no filename specified.
 * In GetSelection, return NULL if there is no selection specified.
 * 
 * Revision 1.3  91/08/13  17:43:59  chua
 * In SetSelection, perform a seek to the desired place.
 * 
 * Revision 1.2  91/07/11  18:31:17  chua
 * In the SetSelection function, only perform if the selection received has
 * a start value > 0.  Also introduced a new variable, perform, which is
 * set to 1 if a valid selection is received.  Only if perform = 1 will 
 * PerformSelection actually do its job.
 * 
 * Revision 1.1  91/07/09  16:47:46  chua
 * 
 * 
 * Revision 1.0  91/07/08  13:46:11  chua
 * Initial revision
 *  */

static char messagesrcsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/messages.c,v 2.12 92/05/29 12:37:50 drapeau Exp $";

#include "main.h"
#include <Browse.h>

static int perform;						    /* To indicate if PerformSelection is to be executed. */

/* 
 * Opens the edit list stored in the filename parameter.
 */
void OpenDoc(filename)
     char **filename;
{
  int result;

  if (strcmp(cdfilename, *filename) != 0)			    /* Check if the filename is the same as the currently existing file */
  {
    result = CheckChanges(LoadFile);				    /* Check if there are unsaved changes */
    if (result == NOTICE_NO)					    /* Proceed to load the file */
    {
      change = 0;
      Browse(*filename, BrowseCheckOpen, 0, "#CD Edit Document#", "cdEdit");
    }
  }
}

/* 
 * Sets the current selection on the edit panel 
 */
void SetSelection(MAESelection* selection)
{
  Msf absoluteStart;
  struct cdrom_msf msf;
  char buf[80];
  
  perform = 0;
  if (selection->start > 0 && selection->start <= lines)	    /* Check that such a selection exist */
  {
    perform = 1;
    if (editnum != -1)						    /* Deselect any current selection */
    {
      xv_set(cdEdit_EditPopup->EditList,
	     PANEL_LIST_SELECT, editnum, FALSE,
	     NULL);
    }
    editnum = selection->start - 1;
    LoadStartEnd();						    /* Load the start and end times on the current selection textfields */
    sprintf(buf, "%d", (duration[editnum] + 500) / 1000);
    xv_set(cdEdit_EditPopup->EditPopupDurationText, PANEL_VALUE, buf, NULL); /* Display the duration in the duration textfield */
    absoluteStart = (Msf) GetCurrentStart();
    if (selection->offset > 0)					    /* Check if there is any offset (play partial selection */
    {
      absoluteStart->frame += selection->offset * 75 / 1000;	    /* Calculate the new start time in msf */
      while (absoluteStart->frame >= 75) 
      {
	absoluteStart->sec ++;
	absoluteStart->frame -= 75;
      }
      while (absoluteStart->sec >= 60) 
      {
	absoluteStart->min ++;
	absoluteStart->sec -= 60;
      }
      offsetStart = absoluteStart;
      offset = 1;
    }
    if (absoluteStart == NULL) 
    {
      return;
    }
    SetDuration(-1);						    /* Display the duration of the current selection */
    xv_set(cdEdit_EditPopup->EditList,				    /* Select the entry to be played */
	   PANEL_LIST_SELECT, editnum, TRUE,
	   NULL);
    msf.cdmsf_min0 = absoluteStart->min;
    msf.cdmsf_sec0 = absoluteStart->sec;
    msf.cdmsf_frame0 = absoluteStart->frame;
    msf.cdmsf_min1 = absoluteStart->min;
    msf.cdmsf_sec1 = absoluteStart->sec;
    msf.cdmsf_frame1 = absoluteStart->frame;
    playerState = PlayMode;
    cdrom_play_msf(fd, msf);
  }
}

/* 
 * Play the current selection 
 */
void PerformSelection()
{
  if (editnum != -1 && perform == 1) 
  {
    PreviewStartEnd(NULL, NULL);
  }
}

/* 
 * Return the current filename.
 */
char** GetDoc(unusedArg)
     void *unusedArg;
{
  return (&cdfilename);
}

/* 
 * Get the current selection number 
 */
MAESelection* GetSelection(unusedArg)
     void *unusedArg;
{
  static MAESelection select;

  select.duration = -1;
  if (editnum >= 0) 
  {
    select.duration = duration[editnum];
    select.start = editnum + 1;
    select.end = editnum + 1;
    select.offset = 0;
    strcpy(select.label, label[editnum]);
  }
  return (&select);
}

/*
 * Halt play.  A stop message is sent to the CD player to halt it.
 */
void HaltSelection()
{
  Stop(NULL, NULL);  
}

/*
 * Pause play.
 */
void PauseSelection()
{
  Pause(NULL, NULL);
}

/*
 * Resume play.  This can only be called after a pause.
 */
void ResumeSelection()
{
  if (playerState == PauseMode)					    /* Make doubly sure that the player is in PauseMode.  If not, do not play, */
  {								    /* since play will then start from the beginning of the CD. */
    Play(NULL, NULL);
  }
}

/*
 * Iconify the application.
 */
void HideApplication()
{
  xv_set(cdEdit_window1->window1, FRAME_CLOSED, TRUE, NULL);	    /* Iconify the app */
}

/*
 * Bring to the front the application, including all its popup windows.
 */
void ShowApplication()
{
  xv_set(cdEdit_window1->window1, FRAME_CLOSED, FALSE, NULL);	    /* Open the app if it is iconified */
  xv_set(cdEdit_window1->window1, XV_SHOW, TRUE, NULL);		    /* Bring the app to the front */
  if (xv_get(cdEdit_EditPopup->EditPopup, XV_SHOW) == TRUE) 
  {
    xv_set(cdEdit_EditPopup->EditPopup, XV_SHOW, TRUE, NULL);
  }
  if (xv_get(cdEdit_PreviewPopup->PreviewPopup, XV_SHOW) == TRUE) 
  {
    xv_set(cdEdit_PreviewPopup->PreviewPopup, XV_SHOW, TRUE, NULL);
  }
}

/* 
 * This application will return the icon bits to the requesting application.
 */
IconData* GetAppIcon()
{
  static IconData returnVal;
  static unsigned short iconBits[] = 
  {
#include "icons/cdEditIcon"
  };

  returnVal.iconData = (char *) malloc(sizeof(iconBits));
  bcopy(iconBits, returnVal.iconData, sizeof(iconBits));
  if (returnVal.iconData) 
  {
    returnVal.dataLength = sizeof(iconBits);
  }
  return(&returnVal);
}


