/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/Pioneer4200Driver.h,v 0.20 92/09/01 17:09:57 drapeau Exp $ */
/* $Log:	Pioneer4200Driver.h,v $
 * Revision 0.20  92/09/01  17:09:57  drapeau
 * Updated copyright notice.
 * Also, added function prototypes to function definitions for better
 * ANSI compliance.
 * 
 * Revision 0.19  92/01/03  16:56:56  drapeau
 * Removed inclusion of string.h so as not to conflict with other files
 * that use this driver.
 * 
 * Revision 0.18  91/09/30  17:06:41  lim
 * Added Pioneer4200Ping.
 * 
 * Revision 0.17  91/08/24  13:38:08  lim
 * 1. Updated to use status codes in new PlayerStatus.h
 * 2. Clear Marker() removed as part of video object.
 * 
 * Revision 0.16  91/08/09  10:49:23  lim
 * Moved 'FrameAndChapter' to 'PlayerStatus.h'
 * 
 * Revision 0.15  91/08/07  13:46:55  lim
 * *** empty log message ***
 * 
 * Revision 0.14  91/08/07  13:07:09  lim
 * 1. Included "videoObj.h" and "PlayerStatus.h"
 * 
 * Revision 0.13  91/08/02  12:53:11  lim
 * Pause() is removed.
 * 
 * Revision 0.12  91/07/29  22:26:42  lim
 * Removed #define's for player status to PlayerStatus.h
 * 
 * Revision 0.11  91/07/27  22:27:58  lim
 * Changed speed from double to int.
 * 
 * Revision 0.10  91/07/12  16:17:40  lim
 * Initial revision implementing VideoObject.
 * 
 * Revision 0.10  91/07/01  14:51:30  lim
 * Initial revision.
 *  */

#include <ctype.h>
#include <fcntl.h>
#include <sys/termio.h>
#include <stdio.h>
#include "videoObj.h"
#include "PlayerStatus.h"

/*  Defines that need to be included  */

/*
  All positive numbers are player return code (except zero) or player
  commands

  Negative numbers are error codes
*/

#define ScanRate  2
#define StepRate  0

#define Pioneer4200CommunicationError     -3
#define Pioneer4200FeatureNotAvailable    -4
#define Pioneer4200MissingArgument        -6
#define Pioneer4200NoDisc                -11
#define Pioneer4200SearchError           -12
#define Pioneer4200DefocussingError      -13
#define Pioneer4200PictureStop           -15
#define Pioneer4200PanicError            -99


static char vhrcs[] = "$Header: /Source/Media/collab/VideoObject/RCS/Pioneer4200Driver.h,v 0.20 92/09/01 17:09:57 drapeau Exp $";


int Pioneer4200Play			(VideoObject*);
int Pioneer4200PlayFromTo		(VideoObject*, int, int, int);
int Pioneer4200FastForward		(VideoObject*);
int Pioneer4200Reverse			(VideoObject*);
int Pioneer4200CalcSpeed		(VideoObject*, int, int);
int Pioneer4200PlayAtSpeedDir		(VideoObject*, int, enum Direction);
int Pioneer4200Step			(VideoObject*, enum Direction);
int Pioneer4200Still			(VideoObject*);
int Pioneer4200Stop			(VideoObject*);
int Pioneer4200SetDefaults		(VideoObject*, int, int, int, int);
int Pioneer4200SetAudio			(VideoObject*, int);
int Pioneer4200SetVideo			(VideoObject*, int);
int Pioneer4200SetAddMode		(VideoObject*, int);
int Pioneer4200SetAddressDisplay	(VideoObject*, int, int);
int Pioneer4200Eject			(VideoObject*);
int Pioneer4200Power			(VideoObject*, int);
int Pioneer4200QueryFrame		(VideoObject*);
int Pioneer4200QueryChapter		(VideoObject*);
int Pioneer4200QueryAudio		(VideoObject*);
int Pioneer4200QueryVideo		(VideoObject*);
int Pioneer4200QueryMedium		(VideoObject*, char*);
int Pioneer4200QueryStatus		(VideoObject*);
int Pioneer4200Ping			(VideoObject*);
void Pioneer4200ErrorDecode		(VideoObject*, int, char*);
