/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/editList.c,v 1.1 92/07/14 14:42:20 drapeau Exp $ */
/* $Log:	editList.c,v $
 * Revision 1.1  92/07/14  14:42:20  drapeau
 * Initial revision
 *  */

#include "VideoFrame.h"
static char editListRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/editList.c,v 1.1 92/07/14 14:42:20 drapeau Exp $";

void	InitEditList()
{
  int	i=0;
  
  for (i=0; i < MaxNumberEditListItems; i++)
  {
    editList.item[i].input1.shown = False;
    editList.item[i].input1.cropped = False;
    editList.item[i].input1.aspectRatio = Any;
    editList.item[i].input1.brightness = 128;
    editList.item[i].input1.contrast = 128;
    editList.item[i].input1.saturation = 128;
    editList.item[i].input1.hue = 128;
    editList.item[i].input1.width = 640;
    editList.item[i].input1.height = 480;
    editList.item[i].input1.x = 0;
    editList.item[i].input1.y = 0;
    
    editList.item[i].input2.shown = False;
    editList.item[i].input2.cropped = False;
    editList.item[i].input2.aspectRatio = Any;
    editList.item[i].input2.brightness = 128;
    editList.item[i].input2.contrast = 128;
    editList.item[i].input2.saturation = 128;
    editList.item[i].input2.hue = 128;
    editList.item[i].input2.width = 640;
    editList.item[i].input2.height = 480;
    editList.item[i].input2.x = 0;
    editList.item[i].input2.y = 0;
  }								    /* end for */
}								    /* end function InitEditList */



/*
 * This function loads a file into the edit list, assuming there 
 * are no errors in opening the file.
 */
int OpenEditList(char* filename, int id)
{
  FILE*	fp;
  char	header[LabelLength + 16];
  char	theString[LabelLength];
  int	i;
  int	dummy;
  
  if (strcmp(filename, "Untitled") == 0)			    /* Check if filename is 'untitled' (unacceptable) */
  {
    AlertMessage("'Untitled' is not an acceptable filename.", "please type in a new one.");
    return(-1);
  }
  if (unsavedChanges == True)					    /* Check if there are unsaved changes */
  {
    return(0);
  }
  fp = fopen(filename, "r");				
  fgets(header, 32, fp);
  if (strcmp(header, "#VideoFrame Document#\n") != 0)		    /* Check if the file is a VideoFrame document */
  {
    AlertMessage("This is not a VideoFrame document.", "Please try another file");
    fclose(fp);
    return(-1);
  }
  fscanf(fp, "#Number of Edits : %d\n", &(editList.numEdits));
  fscanf(fp, "\n");
  for (i=0; i < editList.numEdits; i++)				    /* Load in one edit at a time */
  {
    fscanf(fp, "\n\n\n");
    fscanf(fp, "#Edit Number : %d\n", &dummy);
    fgets(header, (LabelLength + 16), fp);			    /* Scan the label line for this edit */
    strncpy(editList.item[i].label, &header[8], LabelLength-8);
    if (strlen(editList.item[i].label) < (LabelLength - 8))	    /* Remove newline character for label if necessary */
      editList.item[i].label[strlen(editList.item[i].label) -1] = '\0';
    fscanf(fp, "Input1 Shown : %s\n", header);
    if (strcmp(header, "Yes") == 0)
      editList.item[i].input1.shown = True;
    else
      editList.item[i].input1.shown = False;
    fscanf(fp, "Input1 Crop or Squeeze : %s\n", header);
    if (strcmp(header, "Crop") == 0)
      editList.item[i].input1.cropped = True;
    else
      editList.item[i].input1.cropped = False;
    fscanf(fp, "Input1 Aspect Ratio : %s\n", header);
    if (strcmp(header, "Any") == 0)
      editList.item[i].input1.aspectRatio = Any;
    else
      editList.item[i].input1.aspectRatio = Fixed;
    fscanf(fp, "Input1 Brightness : %d\n", &(editList.item[i].input1.brightness));
    fscanf(fp, "Input1 Contrast : %d\n", &(editList.item[i].input1.contrast));
    fscanf(fp, "Input1 Saturation : %d\n", &(editList.item[i].input1.saturation));
    fscanf(fp, "Input1 Hue : %d\n", &(editList.item[i].input1.hue));
    fscanf(fp, "Input1 Width : %d\n", &(editList.item[i].input1.width));
    fscanf(fp, "Input1 Height : %d\n", &(editList.item[i].input1.height));
    fscanf(fp, "Input1 X : %d\n", &(editList.item[i].input1.x));
    fscanf(fp, "Input1 Y : %d\n", &(editList.item[i].input1.y));
    fscanf(fp, "\n");
    
    fscanf(fp, "Input2 Shown : %s\n", header);
    if (strcmp(header, "Yes") == 0)
      editList.item[i].input2.shown = True;
    else
      editList.item[i].input2.shown = False;
    fscanf(fp, "Input2 Crop or Squeeze : %s\n", header);
    if (strcmp(header, "Crop") == 0)
      editList.item[i].input2.cropped = True;
    else
      editList.item[i].input2.cropped = False;
    fscanf(fp, "Input2 Aspect Ratio : %s\n", header);
    if (strcmp(header, "Any") == 0)
      editList.item[i].input2.aspectRatio = Any;
    else
      editList.item[i].input2.aspectRatio = Fixed;
    fscanf(fp, "Input2 Brightness : %d\n", &(editList.item[i].input2.brightness));
    fscanf(fp, "Input2 Contrast : %d\n", &(editList.item[i].input2.contrast));
    fscanf(fp, "Input2 Saturation : %d\n", &(editList.item[i].input2.saturation));
    fscanf(fp, "Input2 Hue : %d\n", &(editList.item[i].input2.hue));
    fscanf(fp, "Input2 Width : %d\n", &(editList.item[i].input2.width));
    fscanf(fp, "Input2 Height : %d\n", &(editList.item[i].input2.height));
    fscanf(fp, "Input2 X : %d\n", &(editList.item[i].input2.x));
    fscanf(fp, "Input2 Y : %d\n", &(editList.item[i].input2.y));
  }								    /* end for... */
  fclose (fp);
  if (currentEdit != NoCurrentEdit)				    /* Deselect any currently selected entry */
  {
    xv_set(VideoFrame_mainWindow->editList,
	   PANEL_LIST_SELECT, currentEdit, FALSE,
	   NULL);
  }
  EmptyList();							    /* Erase old contents of the scrolled list */
  for (i=0; i < editList.numEdits; i++)				    /* Replace the old strings by the new ones */
  {
    FormatEntry(i, &(editList.item[i]), theString);
    xv_set (VideoFrame_mainWindow->editList,
	    PANEL_LIST_INSERT, i,
	    PANEL_LIST_STRING, i, theString,
	    NULL);
  }
  unsavedChanges = False;
  currentEdit = NoCurrentEdit;
  numEdits = editList.numEdits;
  strcpy(editListFileName, filename);
  xv_set(VideoFrame_mainWindow->currentSelectionMessage,
	 PANEL_LABEL_STRING, "Current Selection : None", NULL);
  xv_set(VideoFrame_mainWindow->modifyButton, PANEL_INACTIVE, TRUE, NULL); /* Set the modify, delete buttons to inactive */
  xv_set(VideoFrame_mainWindow->deleteButton, PANEL_INACTIVE, TRUE, NULL);
  UpdateHeader();						    /* Print new document name */
  return(0);
}								    /* end function OpenEditList */




/*
 * This function saves the current edit list into the file
 * specified in the filename passed in as argument.  If the file
 * already exists, the user is warned and given the choice
 * to proceed or abort.
 */
int SaveEditList(char *filename, int id)
{
  FILE*	fp = (FILE*)NULL;
  int	i;
  
  if (strcmp(filename, "Untitled") == 0)			    /* Check if filename is 'untitled' (unacceptable) */
  {
    AlertMessage("'untitled' is not an acceptable filename.",
		 "please type in a new one.");
    return(-1);
  }
  fp = fopen(filename, "w");					    /* Try to open the file for writing */
  if (fp == (FILE*)NULL)					    /* Did an error occur? */
  {								    /* Yes, return an error and exit this function */
    return(-1);
  }
  fprintf(fp, "#VideoFrame Document#\n");			    /* Write the document's header */
  fprintf(fp, "#Number of Edits : %d\n", numEdits);
  for (i=0; i < numEdits; i++) 
  {
    fprintf(fp, "\n\n\n");
    fprintf(fp, "#Edit Number :\t\t\t%d\n", i + 1);
    fprintf(fp, "Label :\t\t\t\t%s\n", editList.item[i].label);
    if (editList.item[i].input1.shown == True)
      fprintf(fp, "Input1 Shown :\t\t\tYes\n");
    else
      fprintf(fp, "Input1 Shown :\t\t\tNo\n");
    if (editList.item[i].input1.cropped == True)
      fprintf(fp, "Input1 Crop or Squeeze :\tCrop\n");
    else
      fprintf(fp, "Input1 Crop or Squeeze :\tSqueeze\n");
    if (editList.item[i].input1.aspectRatio == Any)
      fprintf(fp, "Input1 Aspect Ratio :\t\tAny\n");
    else
      fprintf(fp, "Input1 Aspect Ratio :\t\t4-to-3\n");
    fprintf(fp, "Input1 Brightness :\t\t%d\n", editList.item[i].input1.brightness);
    fprintf(fp, "Input1 Contrast :\t\t%d\n", editList.item[i].input1.contrast);
    fprintf(fp, "Input1 Saturation :\t\t%d\n", editList.item[i].input1.saturation);
    fprintf(fp, "Input1 Hue :\t\t\t%d\n", editList.item[i].input1.hue);
    fprintf(fp, "Input1 Width :\t\t\t%d\n", editList.item[i].input1.width);
    fprintf(fp, "Input1 Height :\t\t\t%d\n", editList.item[i].input1.height);
    fprintf(fp, "Input1 X :\t\t\t%d\n", editList.item[i].input1.x);
    fprintf(fp, "Input1 Y :\t\t\t%d\n", editList.item[i].input1.y);
    fprintf(fp, "\n");
    if (editList.item[i].input2.shown == True)
      fprintf(fp, "Input2 Shown :\t\t\tYes\n");
    else
      fprintf(fp, "Input2 Shown :\t\t\tNo\n");
    if (editList.item[i].input2.cropped == True)
      fprintf(fp, "Input2 Crop or Squeeze :\tCrop\n");
    else
      fprintf(fp, "Input2 Crop or Squeeze :\tSqueeze\n");
    if (editList.item[i].input2.aspectRatio == Any)
      fprintf(fp, "Input2 Aspect Ratio :\t\tAny\n");
    else
      fprintf(fp, "Input2 Aspect Ratio :\t\t4-to-3\n");
    fprintf(fp, "Input2 Brightness :\t\t%d\n", editList.item[i].input2.brightness);
    fprintf(fp, "Input2 Contrast :\t\t%d\n", editList.item[i].input2.contrast);
    fprintf(fp, "Input2 Saturation :\t\t%d\n", editList.item[i].input2.saturation);
    fprintf(fp, "Input2 Hue :\t\t\t%d\n", editList.item[i].input2.hue);
    fprintf(fp, "Input2 Width :\t\t\t%d\n", editList.item[i].input2.width);
    fprintf(fp, "Input2 Height :\t\t\t%d\n", editList.item[i].input2.height);
    fprintf(fp, "Input2 X :\t\t\t%d\n", editList.item[i].input2.x);
    fprintf(fp, "Input2 Y :\t\t\t%d\n", editList.item[i].input2.y);
  }
  fclose (fp);
  unsavedChanges = False;
  strcpy(editListFileName, filename);
  UpdateHeader();						    /* Print new document name */
  return(0);
}								    /* end function SaveEditList */



void LoadCurrentSelection(int row)
{
  Rect	tempRect;
  
  currentEdit = row;
  xv_set(VideoFrame_mainWindow->labelField, PANEL_VALUE,	    /* Print the label for this edit in the textfield */
	 editList.item[row].label, NULL);
  currentSelection.input1.shown = editList.item[row].input1.shown;
  if (currentSelection.input1.shown == True)
  {
    ShowWindow((Panel_item)VideoFrame_mainWindow->input1ShownChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1ShownChoice,
	   PANEL_VALUE, 0, NULL);
  }
  else
  {
    HideWindow((Panel_item)VideoFrame_mainWindow->input1ShownChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1ShownChoice,
	   PANEL_VALUE, 1, NULL);
  }
  
  currentSelection.input1.cropped = editList.item[row].input1.cropped;
  if (currentSelection.input1.cropped == True)
  {
    CropWindow((Panel_item)VideoFrame_mainWindow->input1CroppedChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1CroppedChoice,
	   PANEL_VALUE, 0, NULL);
  }
  else
  {
    SqueezeWindow((Panel_item)VideoFrame_mainWindow->input1CroppedChoice,
		  0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1CroppedChoice,
	   PANEL_VALUE, 1, NULL);
  }  
  currentSelection.input1.aspectRatio = editList.item[row].input1.aspectRatio;
  if (currentSelection.input1.aspectRatio == Fixed)
  {
    SetAspectAny((Panel_item)VideoFrame_mainWindow->input1AspectChoice,
		 0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1AspectChoice,
	   PANEL_VALUE, 1, NULL);
  }
  else
  {
    SetAspect4to3((Panel_item)VideoFrame_mainWindow->input1AspectChoice,
		  0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input1AspectChoice,
	   PANEL_VALUE, 0, NULL);
  }  
  currentSelection.input1.brightness = editList.item[row].input1.brightness;
  BrightnessHandler((Panel_item)VideoFrame_mainWindow->input1BrightSlider,
		    currentSelection.input1.brightness, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input1BrightSlider,
	 PANEL_VALUE, currentSelection.input1.brightness, NULL);
  
  currentSelection.input1.contrast = editList.item[row].input1.contrast;
  ContrastHandler((Panel_item)VideoFrame_mainWindow->input1ContrastSlider,
		  currentSelection.input1.contrast, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input1ContrastSlider,
	 PANEL_VALUE, currentSelection.input1.contrast, NULL);
  
  currentSelection.input1.saturation = editList.item[row].input1.saturation;
  SaturationHandler((Panel_item)VideoFrame_mainWindow->input1SaturationSlider,
		    currentSelection.input1.saturation, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input1SaturationSlider,
	 PANEL_VALUE, currentSelection.input1.saturation, NULL);
  
  currentSelection.input1.hue = editList.item[row].input1.hue;
  HueHandler((Panel_item)VideoFrame_mainWindow->input1HueSlider,
	     currentSelection.input1.hue, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input1HueSlider,
	 PANEL_VALUE, currentSelection.input1.hue, NULL);
  
  currentSelection.input1.width = editList.item[row].input1.width;
  currentSelection.input1.height = editList.item[row].input1.height;
  currentSelection.input1.x = editList.item[row].input1.x;
  currentSelection.input1.y = editList.item[row].input1.y;
  tempRect.r_left = currentSelection.input1.x;
  tempRect.r_top = currentSelection.input1.y;
  tempRect.r_width = currentSelection.input1.width;
  tempRect.r_height = currentSelection.input1.height;
  frame_set_rect(VideoFrame_inputWindow1->inputWindow1, &tempRect);
  
  currentSelection.input2.shown = editList.item[row].input2.shown;
  if (currentSelection.input2.shown == True)
  {
    ShowWindow((Panel_item)VideoFrame_mainWindow->input2ShownChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2ShownChoice,
	   PANEL_VALUE, 0, NULL);
  }
  else
  {
    HideWindow((Panel_item)VideoFrame_mainWindow->input2ShownChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2ShownChoice,
	   PANEL_VALUE, 1, NULL);
  }
  
  currentSelection.input2.cropped = editList.item[row].input2.cropped;
  if (currentSelection.input2.cropped == True)
  {
    CropWindow((Panel_item)VideoFrame_mainWindow->input2CroppedChoice,
	       0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2CroppedChoice,
	   PANEL_VALUE, 0, NULL);
  }
  else
  {
    SqueezeWindow((Panel_item)VideoFrame_mainWindow->input2CroppedChoice,
		  0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2CroppedChoice,
	   PANEL_VALUE, 1, NULL);
  }  
  currentSelection.input2.aspectRatio = editList.item[row].input2.aspectRatio;
  if (currentSelection.input2.aspectRatio == Fixed)
  {
    SetAspectAny((Panel_item)VideoFrame_mainWindow->input2AspectChoice,
		 0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2AspectChoice,
	   PANEL_VALUE, 1, NULL);
  }
  else
  {
    SetAspect4to3((Panel_item)VideoFrame_mainWindow->input2AspectChoice,
		  0, (Event*)NULL);
    xv_set(VideoFrame_mainWindow->input2AspectChoice,
	   PANEL_VALUE, 0, NULL);
  }  
  currentSelection.input2.brightness = editList.item[row].input2.brightness;
  BrightnessHandler((Panel_item)VideoFrame_mainWindow->input2BrightSlider,
		    currentSelection.input2.brightness, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input2BrightSlider,
	 PANEL_VALUE, currentSelection.input2.brightness, NULL);
  
  currentSelection.input2.contrast = editList.item[row].input2.contrast;
  ContrastHandler((Panel_item)VideoFrame_mainWindow->input2ContrastSlider,
		  currentSelection.input2.contrast, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input2ContrastSlider,
	 PANEL_VALUE, currentSelection.input2.contrast, NULL);
  
  currentSelection.input2.saturation = editList.item[row].input2.saturation;
  SaturationHandler((Panel_item)VideoFrame_mainWindow->input2SaturationSlider,
		    currentSelection.input2.saturation, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input2SaturationSlider,
	 PANEL_VALUE, currentSelection.input2.saturation, NULL);
  
  currentSelection.input2.hue = editList.item[row].input2.hue;
  HueHandler((Panel_item)VideoFrame_mainWindow->input2HueSlider,
	     currentSelection.input2.hue, (Event*)NULL);
  xv_set(VideoFrame_mainWindow->input2HueSlider,
	 PANEL_VALUE, currentSelection.input2.hue, NULL);
  
  currentSelection.input2.width = editList.item[row].input2.width;
  currentSelection.input2.height = editList.item[row].input2.height;
  currentSelection.input2.x = editList.item[row].input2.x;
  currentSelection.input2.y = editList.item[row].input2.y;
  
  tempRect.r_left = currentSelection.input2.x;
  tempRect.r_top = currentSelection.input2.y;
  tempRect.r_width = currentSelection.input2.width;
  tempRect.r_height = currentSelection.input2.height;
  frame_set_rect(VideoFrame_inputWindow2->inputWindow2, &tempRect);
}								    /* end function LoadCurrentSelection */
