/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/zoom.c,v 1.1 91/10/02 16:11:16 chua Exp Locker: drapeau $ */
/* $Log:	zoom.c,v $
 * Revision 1.1  91/10/02  16:11:16  chua
 * In ZoomSliderNotify, change the values in the grid menu so that the 
 * correct time interval is displayed.  It is now in terms of mins and secs, 
 * instead of pixels.
 * 
 * Revision 1.0  91/09/30  17:03:13  chua
 * Update to version 1.0
 * 
 * Revision 0.45  91/08/05  13:07:50  chua
 * When calculting the canvas start, instead of using the number 50, use the constants,
 * TimeLineInterval and PixelsPerSecond to arrive at the number instead.
 * 
 * Revision 0.44  91/07/17  14:36:59  chua
 * When zooming is done, set the time of the starting canvas position of the new zoomed
 * display to be approximately the same as that of the starting position prior to
 * zooming.
 * 
 * Revision 0.43  91/07/17  10:40:28  chua
 * In the ZoomSliderNotify procedure, there is no need to draw the playback head, as
 * this is taken care of in the call to ShowNewCanvas, which replaces the call to
 * RepaintCanvas (there is no need to redraw the AppCanvas).
 * 
 * Revision 0.42  91/07/09  17:03:24  chua
 * In the definition of ZoomSliderNotify, make it return an integer, to be
 * consistent with what Guide generated.
 * 
 * Revision 0.41  91/06/26  16:55:36  chua
 * no changes
 * 
 * Revision 0.40  91/06/24  13:21:59  chua
 * This file contains the zoom notify routine for the zoom slider found
 * in the TimeLine Editor main window.
 *  */

static char zoomrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/zoom.c,v 1.1 91/10/02 16:11:16 chua Exp Locker: drapeau $";

#include "main.h"

/*
 * Notify callback function for `ZoomSlider'.
 * This function will zoom the display to the level indicated on the zoom slider.
 * It will set the canvas start position so that the new zoomed display will start from approximately the same time (which might be slightly off due to
 * rounding errors).
 * It will also change the entries in the grid menu so that the correct time intervals are displayed.
 */
int ZoomSliderNotify(item, value, event)
     Panel_item		item;
     int		value;
     Event		*event;
{
  int viewStart;
  int oldcanvasStart;
  int gridValue, gridMin;
  int previousZoomLevel;
  int i;
  static char **buf;
  char *bufmin, *bufsec;
  Menu menu;
  Menu_item mi[5];
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  bufsec = (char *) malloc(20);
  bufmin = (char *) malloc(20);
  buf = (char **) malloc (sizeof (char *) * 6);
  for (i = 0; i <= 5; i++) 
    buf[i] = (char *) malloc(40);
  viewStart = (int) xv_get(tlFrame->DrawScrollbarVer, SCROLLBAR_VIEW_START);
  oldcanvasStart = (tlFrame->canvasStart + viewStart) * tlFrame->zoomLevel; /* Get the previous canvas starting position */
  previousZoomLevel = tlFrame->zoomLevel;
  tlFrame->zoomLevel = xv_get(item, PANEL_VALUE);		    /* Get the new zoom level */
  menu = xv_get(tlFrame->TimeLine_window->optionsButton, PANEL_ITEM_MENU);
  gridValue = previousZoomLevel / 2;				    /* Find the menu item for the 5 pixels grid spacing */
  if (previousZoomLevel == 1) 
    sprintf(bufsec, "1/2");
  else if (previousZoomLevel%2 == 0)
    sprintf(bufsec, "%d", gridValue);
  else
    sprintf(bufsec, "%d 1/2", gridValue);
  if (previousZoomLevel > 2)
    sprintf (buf[0], "%s seconds", bufsec);
  else
    sprintf (buf[0], "%s second", bufsec);
  mi[0] = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, buf[0],
			    NULL);
  for (i=1; i <= 5; i++)					    /* Find the menu item for the 10, 20, 30, 40 and 50 pixels grid spacing items */
  {
    gridValue = previousZoomLevel * i;				    /* Find the menu item for the 10 pixels grid spacing */
    gridMin = 0;
    while (gridValue >= 60)					    /* Convert to minutes and seconds if necessary */
    {
      gridValue -= 60;
      gridMin ++;
    }
    if (gridMin > 1)
      sprintf(bufmin, "%d minutes", gridMin);
    else
      sprintf(bufmin, "%d minute", gridMin);
    if (gridValue > 1)
      sprintf(bufsec, "%d seconds", gridValue);
    else
      sprintf(bufsec, "%d second", gridValue);
    if (gridMin > 0) 
      sprintf (buf[i], "%s %s", bufmin, bufsec);
    else
      strcpy (buf[i], bufsec);
    mi[i] = (Menu_item) xv_find (menu, MENUITEM,
			       MENU_STRING, buf[i],
			       NULL);
  }
  gridValue = tlFrame->zoomLevel / 2;				    /* Set the menu item for the 5 pixels grid spacing */
  if (tlFrame->zoomLevel == 1) 
    sprintf(bufsec, "1/2");
  else if (tlFrame->zoomLevel%2 == 0)
    sprintf(bufsec, "%d", gridValue);
  else
    sprintf(bufsec, "%d 1/2", gridValue);
  if (tlFrame->zoomLevel > 2) 
    sprintf (buf[0], "%s seconds", bufsec);
  else
    sprintf (buf[0], "%s second", bufsec);
  xv_set(mi[0], MENU_STRING, buf[0], NULL);
  for (i=1; i <= 5; i++)					    /* Set the menu item for the 10, 20, 30, 40 and 50 pixels grid spacing items */
  {
    gridValue = tlFrame->zoomLevel * i;				    /* Set the menu item for the 10 pixels grid spacing */
    gridMin = 0;
    while (gridValue >= 60)					    /* Convert to minutes and seconds if necessary */
    {
      gridValue -= 60;
      gridMin ++;
    }
    if (gridMin > 1)
      sprintf(bufmin, "%d minutes", gridMin);
    else
      sprintf(bufmin, "%d minute", gridMin);
    if (gridValue > 1)
      sprintf(bufsec, "%d seconds", gridValue);
    else
      sprintf(bufsec, "%d second", gridValue);
    if (gridMin > 0) 
      sprintf (buf[i], "%s %s", bufmin, bufsec);
    else
      strcpy (buf[i], bufsec);
    xv_set(mi[i], MENU_STRING, buf[i], NULL);
  }
  tlFrame->canvasStart = oldcanvasStart / tlFrame->zoomLevel;
  tlFrame->canvasStart = tlFrame->canvasStart - tlFrame->canvasStart % (TimeLineInterval * PixelsPerSecond); 
  ShowNewCanvas(tlFrame, 1);
}







