/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/collab/TimeLine/RCS/cursor.c,v 1.0 91/09/30 16:53:19 chua Exp Locker: drapeau $ */
/* $Log:	cursor.c,v $
 * Revision 1.0  91/09/30  16:53:19  chua
 * Update to version 1.0
 * 
 * Revision 0.41  91/09/23  17:07:12  chua
 * 
 * 
 * Revision 0.40  91/09/20  15:03:08  chua
 * Contains functions to display the cursor as busy or normal.
 *  */

static char cursorrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/cursor.c,v 1.0 91/09/30 16:53:19 chua Exp Locker: drapeau $";

#include "main.h"
#include <xview/cursor.h>

static Xv_Cursor busyCursor;
static Xv_Cursor normalCursor;

void CreateCursor() 
{
  busyCursor = (Xv_Cursor) xv_create(XV_NULL, CURSOR,
				CURSOR_SRC_CHAR, OLC_BUSY_PTR,				 
				NULL);
  normalCursor = (Xv_Cursor) xv_create(XV_NULL, CURSOR,
				CURSOR_SRC_CHAR, OLC_BASIC_PTR,				 
				NULL);
}

void NormalCursor(tlFrame)
     TimeLineFramePtr tlFrame;
{
  xv_set(xv_get(tlFrame->TimeLine_window->controls, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, normalCursor, NULL);	
  xv_set(xv_get(tlFrame->TimeLine_window->DrawCanvas, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, normalCursor, NULL);		
  xv_set(xv_get(tlFrame->TimeLine_window->AppCanvas, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, normalCursor, NULL);		
}

void BusyCursor(tlFrame) 
     TimeLineFramePtr tlFrame;
{
  xv_set(xv_get(tlFrame->TimeLine_window->controls, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, busyCursor, NULL);	
  xv_set(xv_get(tlFrame->TimeLine_window->DrawCanvas, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, busyCursor, NULL);		
  xv_set(xv_get(tlFrame->TimeLine_window->AppCanvas, CANVAS_NTH_PAINT_WINDOW, 0),
	 WIN_CURSOR, busyCursor, NULL);		
  
}

