/*
 * TimeLine_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `TimeLine.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "TimeLine_ui.h"

/*
 * Create object `EditMenu' in the specified instance.
 */
Xv_opaque
TimeLine_EditMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	CutHandler(Menu_item, Menu_generate);
	extern Menu_item	CopyHandler(Menu_item, Menu_generate);
	extern Menu_item	PasteHandler(Menu_item, Menu_generate);
	extern Menu_item	DeleteHandler(Menu_item, Menu_generate);
	extern Menu_item	ClearAllHandler(Menu_item, Menu_generate);
	extern Menu_item	ShowClipboardHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Edit",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cut",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, CutHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Copy",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, CopyHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Paste",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PasteHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Delete",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, DeleteHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear All",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ClearAllHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show Clipboard ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ShowClipboardHandler,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Edit",
		NULL);
	return obj;
}

/*
 * Create object `PlayMenu' in the specified instance.
 */
Xv_opaque
TimeLine_PlayMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	PlayFromHandler(Menu_item, Menu_generate);
	extern Menu_item	PlayHandler(Menu_item, Menu_generate);
	extern Menu_item	PlaySelectedHandler(Menu_item, Menu_generate);
	extern Menu_item	SynchronizeDocument(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Play",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play from insertion point",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PlayFromHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play whole document",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PlayHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play selected region",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PlaySelectedHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Synchronize This Document",
			MENU_GEN_PROC, SynchronizeDocument,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Play",
		NULL);
	return obj;
}

/*
 * Create object `AppMenu' in the specified instance.
 */
Xv_opaque
TimeLine_AppMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	UpdateAppsHandler(Menu_item, Menu_generate);
	extern Menu_item	ShowEditInfoHandler(Menu_item, Menu_generate);
	extern Menu_item	DeleteAppHandler(Menu_item, Menu_generate);
	extern Menu_item	ShowApplicationHandler(Menu_item, Menu_generate);
	extern Menu_item	HideApplicationHandler(Menu_item, Menu_generate);
	extern Menu_item	MuteAppHandler(Menu_item, Menu_generate);
	extern Menu_item	RemoveMuteAppHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Applications",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Update Applications List",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, UpdateAppsHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show edit info for an application ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ShowEditInfoHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Delete selected application",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, DeleteAppHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show application",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ShowApplicationHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Hide application",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, HideApplicationHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Mute application",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, MuteAppHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Remove mute from application",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, RemoveMuteAppHandler,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Applications",
		NULL);
	return obj;
}

/*
 * Create object `DocumentMenu' in the specified instance.
 */
Xv_opaque
TimeLine_DocumentMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	AboutHandler(Menu_item, Menu_generate);
	extern Menu_item	NewHandler(Menu_item, Menu_generate);
	extern Menu_item	OpenFileHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveFileHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveAsFileHandler(Menu_item, Menu_generate);
	extern Menu_item	CloseHandler(Menu_item, Menu_generate);
	extern Menu_item	QuitHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "About TimeLine Editor ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, AboutHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "New ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, NewHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, OpenFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, SaveFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save as ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, SaveAsFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, CloseHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Quit",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, QuitHandler,
			NULL,
		MENU_DEFAULT, 4,
		MENU_GEN_PIN_WINDOW, owner, "Document",
		NULL);
	return obj;
}

/*
 * Create object `GridMenu' in the specified instance.
 */
Xv_opaque
TimeLine_GridMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	GridOffHandler(Menu_item, Menu_generate);
	extern Menu_item	FivePixelHandler(Menu_item, Menu_generate);
	extern Menu_item	TenPixelHandler(Menu_item, Menu_generate);
	extern Menu_item	TwentyPixelHandler(Menu_item, Menu_generate);
	extern Menu_item	ThirtyPixelHandler(Menu_item, Menu_generate);
	extern Menu_item	FortyPixelHandler(Menu_item, Menu_generate);
	extern Menu_item	FiftyPixelHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_CHOICE_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Grid",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Grid Off",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, GridOffHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "1/2 second",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, FivePixelHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "1 second",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, TenPixelHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "2 seconds",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, TwentyPixelHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "3 seconds",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ThirtyPixelHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "4 seconds",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, FortyPixelHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "5 seconds",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, FiftyPixelHandler,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `OptionsMenu' in the specified instance.
 */
Xv_opaque
TimeLine_OptionsMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	ShowRegionInfoHandler(Menu_item, Menu_generate);
	extern Menu_item	InsertBlankTimeHandler(Menu_item, Menu_generate);
	extern Menu_item	InsertPauseMarkerHandler(Menu_item, Menu_generate);
	extern Menu_item	ConnectPortManagerHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Options",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show Region Info ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ShowRegionInfoHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Insert Blank Time ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, InsertBlankTimeHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Insert/Delete Pause Marker ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, InsertPauseMarkerHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Grid",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_PULLRIGHT, TimeLine_GridMenu_create(ip, owner),
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Connect with new Port Manager ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ConnectPortManagerHandler,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Options",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `window'.
 */
TimeLine_window_objects *
TimeLine_window_objects_initialize(TimeLine_window_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (TimeLine_window_objects *) calloc(1, sizeof (TimeLine_window_objects))))
		return (TimeLine_window_objects *) NULL;
	if (!ip->window)
		ip->window = TimeLine_window_window_create(ip, owner);
	if (!ip->controls)
		ip->controls = TimeLine_window_controls_create(ip, ip->window);
	if (!ip->documentButton)
		ip->documentButton = TimeLine_window_documentButton_create(ip, ip->controls);
	if (!ip->appButton)
		ip->appButton = TimeLine_window_appButton_create(ip, ip->controls);
	if (!ip->editButton)
		ip->editButton = TimeLine_window_editButton_create(ip, ip->controls);
	if (!ip->playButton)
		ip->playButton = TimeLine_window_playButton_create(ip, ip->controls);
	if (!ip->optionsButton)
		ip->optionsButton = TimeLine_window_optionsButton_create(ip, ip->controls);
	if (!ip->ZoomSlider)
		ip->ZoomSlider = TimeLine_window_ZoomSlider_create(ip, ip->controls);
	if (!ip->pauseButton)
		ip->pauseButton = TimeLine_window_pauseButton_create(ip, ip->controls);
	if (!ip->stopButton)
		ip->stopButton = TimeLine_window_stopButton_create(ip, ip->controls);
	if (!ip->playIconButton)
		ip->playIconButton = TimeLine_window_playIconButton_create(ip, ip->controls);
	if (!ip->MoveCanvasFastLeftButton)
		ip->MoveCanvasFastLeftButton = TimeLine_window_MoveCanvasFastLeftButton_create(ip, ip->controls);
	if (!ip->MoveCanvasLeftButton)
		ip->MoveCanvasLeftButton = TimeLine_window_MoveCanvasLeftButton_create(ip, ip->controls);
	if (!ip->MoveCanvasRightButton)
		ip->MoveCanvasRightButton = TimeLine_window_MoveCanvasRightButton_create(ip, ip->controls);
	if (!ip->MoveCanvasFastRightButton)
		ip->MoveCanvasFastRightButton = TimeLine_window_MoveCanvasFastRightButton_create(ip, ip->controls);
	if (!ip->ResetCanvasButton)
		ip->ResetCanvasButton = TimeLine_window_ResetCanvasButton_create(ip, ip->controls);
	if (!ip->AppCanvas)
		ip->AppCanvas = TimeLine_window_AppCanvas_create(ip, ip->window);
	if (!ip->DrawCanvas)
		ip->DrawCanvas = TimeLine_window_DrawCanvas_create(ip, ip->window);
	if (!ip->TimeCanvas)
		ip->TimeCanvas = TimeLine_window_TimeCanvas_create(ip, ip->window);
	return ip;
}

/*
 * Create object `window' in the specified instance.
 */
Xv_opaque
TimeLine_window_window_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		window_image;
	static unsigned short	window_bits[] = {
#include "icons/TimeLine.icon"
	};
	
	window_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, window_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 804,
		XV_HEIGHT, 234,
		XV_LABEL, "TimeLine Editor",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window_image,
			NULL),
		NULL);
	return obj;
}

/*
 * Create object `controls' in the specified instance.
 */
Xv_opaque
TimeLine_window_controls_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 92,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `documentButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_documentButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, TimeLine_DocumentMenu_create((caddr_t) ip, ip->window),
		NULL);
	return obj;
}

/*
 * Create object `appButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_appButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 132,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Applications",
		PANEL_ITEM_MENU, TimeLine_AppMenu_create((caddr_t) ip, ip->window),
		NULL);
	return obj;
}

/*
 * Create object `editButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_editButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 260,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Edit",
		PANEL_ITEM_MENU, TimeLine_EditMenu_create((caddr_t) ip, ip->window),
		NULL);
	return obj;
}

/*
 * Create object `playButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_playButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 336,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play",
		PANEL_ITEM_MENU, TimeLine_PlayMenu_create((caddr_t) ip, ip->window),
		NULL);
	return obj;
}

/*
 * Create object `optionsButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_optionsButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 416,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Options",
		PANEL_ITEM_MENU, TimeLine_OptionsMenu_create((caddr_t) ip, ip->window),
		NULL);
	return obj;
}

/*
 * Create object `ZoomSlider' in the specified instance.
 */
Xv_opaque
TimeLine_window_ZoomSlider_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		ZoomSliderNotify(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 520,
		XV_Y, 20,
		PANEL_SLIDER_WIDTH, 150,
		PANEL_TICKS, 0,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Zoom : ",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 1,
		PANEL_MAX_VALUE, 40,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, ZoomSliderNotify,
		NULL);
	return obj;
}

/*
 * Create object `pauseButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_pauseButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		PauseResume(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		pauseButton_image;
	static unsigned short	pauseButton_bits[] = {
#include "icons/pauseIcon"
	};
	
	pauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, pauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, pauseButton_image,
		PANEL_NOTIFY_PROC, PauseResume,
		NULL);
	return obj;
}

/*
 * Create object `stopButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_stopButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		Stop(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		stopButton_image;
	static unsigned short	stopButton_bits[] = {
#include "icons/stopIcon"
	};
	
	stopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, stopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, stopButton_image,
		PANEL_NOTIFY_PROC, Stop,
		NULL);
	return obj;
}

/*
 * Create object `playIconButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_playIconButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		Play(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		playIconButton_image;
	static unsigned short	playIconButton_bits[] = {
#include "icons/playIcon"
	};
	
	playIconButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, playIconButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 340,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, playIconButton_image,
		PANEL_NOTIFY_PROC, Play,
		NULL);
	return obj;
}

/*
 * Create object `MoveCanvasFastLeftButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_MoveCanvasFastLeftButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		MoveCanvasFastLeft(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		MoveCanvasFastLeftButton_image;
	static unsigned short	MoveCanvasFastLeftButton_bits[] = {
#include "icons/FastLeftCanvasIcon"
	};
	
	MoveCanvasFastLeftButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, MoveCanvasFastLeftButton_bits,
		XV_WIDTH, 16,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 528,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, MoveCanvasFastLeftButton_image,
		PANEL_NOTIFY_PROC, MoveCanvasFastLeft,
		NULL);
	return obj;
}

/*
 * Create object `MoveCanvasLeftButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_MoveCanvasLeftButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		MoveCanvasLeft(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		MoveCanvasLeftButton_image;
	static unsigned short	MoveCanvasLeftButton_bits[] = {
#include "icons/LeftCanvasIcon"
	};
	
	MoveCanvasLeftButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, MoveCanvasLeftButton_bits,
		XV_WIDTH, 16,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 568,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, MoveCanvasLeftButton_image,
		PANEL_NOTIFY_PROC, MoveCanvasLeft,
		NULL);
	return obj;
}

/*
 * Create object `MoveCanvasRightButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_MoveCanvasRightButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		MoveCanvasRight(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		MoveCanvasRightButton_image;
	static unsigned short	MoveCanvasRightButton_bits[] = {
#include "icons/RightCanvasIcon"
	};
	
	MoveCanvasRightButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, MoveCanvasRightButton_bits,
		XV_WIDTH, 16,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 668,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, MoveCanvasRightButton_image,
		PANEL_NOTIFY_PROC, MoveCanvasRight,
		NULL);
	return obj;
}

/*
 * Create object `MoveCanvasFastRightButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_MoveCanvasFastRightButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		MoveCanvasFastRight(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		MoveCanvasFastRightButton_image;
	static unsigned short	MoveCanvasFastRightButton_bits[] = {
#include "icons/FastRightCanvasIcon"
	};
	
	MoveCanvasFastRightButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, MoveCanvasFastRightButton_bits,
		XV_WIDTH, 16,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 708,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, MoveCanvasFastRightButton_image,
		PANEL_NOTIFY_PROC, MoveCanvasFastRight,
		NULL);
	return obj;
}

/*
 * Create object `ResetCanvasButton' in the specified instance.
 */
Xv_opaque
TimeLine_window_ResetCanvasButton_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern void		ResetCanvas(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 608,
		XV_Y, 56,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "RESET",
		PANEL_NOTIFY_PROC, ResetCanvas,
		NULL);
	return obj;
}

/*
 * Create object `AppCanvas' in the specified instance.
 */
Xv_opaque
TimeLine_window_AppCanvas_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern Notify_value	AppCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	AppCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 90,
		XV_WIDTH, 112,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, AppCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) AppCanvasEventHandler, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `DrawCanvas' in the specified instance.
 */
Xv_opaque
TimeLine_window_DrawCanvas_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern Notify_value	DrawCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	DrawCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 108,
		XV_Y, 90,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 102,
		CANVAS_REPAINT_PROC, DrawCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) DrawCanvasEventHandler, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `TimeCanvas' in the specified instance.
 */
Xv_opaque
TimeLine_window_TimeCanvas_create(TimeLine_window_objects *ip, Xv_opaque owner)
{
	extern Notify_value	TimeCanvasEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	TimeCanvasRepaintHandler(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 108,
		XV_Y, 190,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, TimeCanvasRepaintHandler,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) TimeCanvasEventHandler, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

