/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*$Header: /Source/Media/collab/QuoteMaker/RCS/font.c,v 2.13 92/09/25 14:31:26 drapeau Exp $*/
/* $Log:	font.c,v $
 * Revision 2.13  92/09/25  14:31:26  drapeau
 * Fixed errors in the way the quoted text window was being located.  The
 * earlier version used the XView attributes "XV_WIDTH", "XV_HEIGHT", "XV_X",
 * and "XV_Y".  This version now uses the more proper "frame_get_rect()" and
 * "frame_set_rect()" functions for window placement and sizing.
 * Also, some cosmetic changes were made to enhance readability and ANSI
 * compliance.
 * 
 * Revision 2.12  92/05/29  12:41:23  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 2.11  92/05/14  15:43:31  drapeau
 * * Updated copyright information.
 * 
 * Revision 2.10  91/12/31  18:41:45  drapeau
 * Removed the inclusion of string.h, since XView will include the
 * appropriate definitions.
 * 
 * Revision 2.0  91/09/30  15:02:28  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.6  91/09/15  20:34:05  derek
 * The function ShowPreviewFunctionsPanel() is removed.  Also, in 
 * PreloadFontOntoQTW(), a statement is added to clear the quote window
 * before loading fonts.
 * 
 * Revision 1.5  91/09/05  15:47:59  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.4  91/08/27  14:37:31  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.3  91/08/26  12:10:13  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.2  91/07/22  16:46:54  derek
 * I have added 4 buttons to get and set the current
 * location and size of the quoted text window.
 * 
 * Revision 1.1  91/07/15  12:19:00  derek
 * Initial revision
 *  */
static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/font.c,v 2.13 92/09/25 14:31:26 drapeau Exp $";

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include "Sender.h"
#include "Receiver.h"
#include "quoteMakerDefs.h"



Xv_font *listFont;						    /*  Font used in the main panel and the quoted...   */
								    /*  text window specs' panel.                       */
Xv_font *displayFont;						    /*  Font used in the Quoted Text Window.            */
Xv_font *annotateFont;

int     currentFontFamily;
int	currentFontStyle;
int	currentFontSize;

char    *FontFamily[] = {"Default",
			"Default_Fixedwidth",
			"Lucida",
			"Lucida_Fixedwidth",
			"Roman",
			"Serif",
			"Cour"
			};

char    *FontStyle[]  = {"Default",
			"Normal",
			"Bold",
			"Italic",
			"Bold_Italic"
			};


char  *
  UpperCase(s)
char *s;
{
  int  i;
  static int  offset = 'A' - 'a';
  static char result[30];
  
  for(i = 0; i<strlen(s); i++)
  {
    if (s[i] >= 'a' && s[i] <= 'z')
      result[i] = s[i] + offset;
  }
  result[i] = 0;
  return(result);
}


/*
 *  This function gives the macro (which is in fact a pointer
 *  to a string) corresponding to the item number in the
 *  font family scrolled list.
 */
char *
  GetFontFamilyFromItemNum(inum)
int  inum;
{
  static char familyName[40];

  switch(inum) 
  {
   case 0:
    return(strcpy(familyName, FONT_FAMILY_DEFAULT));
   case 1:
    return(strcpy(familyName, FONT_FAMILY_DEFAULT_FIXEDWIDTH));
   case 2:
    return(strcpy(familyName, FONT_FAMILY_LUCIDA));
   case 3:
    return(strcpy(familyName, FONT_FAMILY_LUCIDA_FIXEDWIDTH));
   case 4:
    return(strcpy(familyName, FONT_FAMILY_ROMAN));
   case 5:
    return(strcpy(familyName, FONT_FAMILY_SERIF));
   case 6:
    return(strcpy(familyName, FONT_FAMILY_COUR));
   default:
    fprintf(stderr, "Unknown Font Family Scrolled List option.\n");
    exit(0);
  }
}


/*
 *  This function gives the macro (which is in fact a pointer
 *  to a string) corresponding to the item number in the
 *  font style scrolled list.
 */
char *
  GetFontStyleFromItemNum(inum)
int  inum;
{
  static char   styleName[40];

  switch(inum)
  {
   case 0:
    return(strcpy(styleName, FONT_STYLE_DEFAULT));
   case 1:
    return(strcpy(styleName, FONT_STYLE_NORMAL));
   case 2:
    return(strcpy(styleName, FONT_STYLE_BOLD));
   case 3:
    return(strcpy(styleName, FONT_STYLE_ITALIC));
   case 4:
    return(strcpy(styleName, FONT_STYLE_BOLD_ITALIC));
   default:
    fprintf(stderr, "Unknown Font Style Scrolled List option.\n");
    exit(0);
  }
}


/*
 *  This function initializes the Font Family Scrolled List
 *  and the Font Style Scrolled List.
 */
void
  InitFontPanel()
{
  int   i;

  for(i=0; i< MAX_NUM_OF_FONT_FAMILIES ; i++)	
  {
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontFamilyList,
	   PANEL_LIST_INSERT, i,
	   PANEL_LIST_STRING, i, FontFamily[i],
	   PANEL_LIST_FONT, i, listFont,
	   NULL);
  }

  for(i=0; i< MAX_NUM_OF_FONT_STYLES ; i++)
  {
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontStyleList,
	   PANEL_LIST_INSERT, i,
	   PANEL_LIST_STRING, i, FontStyle[i],
	   PANEL_LIST_FONT, i, listFont,
	   NULL);
  }
}
  

void
  SetFontPanel(familyNum, styleNum, size)
{
  if (currentFontFamily != NONE_SELECTED)
  {
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontFamilyList,
	   PANEL_LIST_SELECT, currentFontFamily, FALSE, NULL);
  } 

  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontFamilyList,
	 PANEL_LIST_SELECT, familyNum, TRUE, NULL);
  currentFontFamily = familyNum;
  
  if (currentFontStyle != NONE_SELECTED)
  {
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontStyleList,
	   PANEL_LIST_SELECT, currentFontStyle, FALSE, NULL);
  }

  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontStyleList,
	 PANEL_LIST_SELECT, styleNum, TRUE, NULL);
  currentFontStyle = styleNum;
  
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
	 PANEL_VALUE, size, NULL);
  currentFontSize = size;
}


void SetQuotedTextWindowLocation(int x, int y)
{
  static Rect  tempRect;
  
  frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
  tempRect.r_top = y + FRAME_Y_OFFSET;				    /*  Some mysterious offsets need to work around...  */
  tempRect.r_left = x + FRAME_X_OFFSET;				    /*  ...the current location. */
  
  frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
}  


void
  SetQuotedTextWindowSize(width, height)
int  width, height;
{
  static Rect  tempRect;

  frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
  tempRect.r_width = width;
  tempRect.r_height = height;

  frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
}								    /* end function SetQuotedTextWindowSize */

  
void
  SetQuotedTextWindowFont(family, style, size)
int family, style, size;
{
  displayFont = (Xv_font *) xv_find(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
				    FONT,
				    FONT_FAMILY, GetFontFamilyFromItemNum(family),
				    FONT_STYLE, GetFontStyleFromItemNum(style),
				    FONT_SIZE, size,
				    NULL);

  if (displayFont)
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
	   XV_FONT, displayFont,
	   NULL);
  }
  else
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Sorry, this combination of font family and style is not currently available.");
  }
  
}

/*
 *  This function preload fonts onto the Quoted Text Window.
 */
void
  PreloadFontsOntoQTW()
{
  int   counter;
  
  ClearQuotedTextWindow();
  for(counter = 0; counter < editList.numItems ; counter++)	    
  {								    
    displayFont = (Xv_font *) xv_find(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
				      FONT,
				      FONT_FAMILY, GetFontFamilyFromItemNum(editList.fontFamily[counter]),
				      FONT_STYLE, GetFontStyleFromItemNum(editList.fontStyle[counter]),
				      FONT_SIZE, editList.fontSize[counter],
				      NULL);
    if (displayFont)
    {
      xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextPane,
	     XV_FONT, displayFont,
	     NULL);
    }
  }
}								    /* end function PreloadFontsOntoQTW */
