/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstro.h,v 1.17 92/05/29 12:39:40 drapeau Exp $ */
/* $Log:	MAEstro.h,v $
 * Revision 1.17  92/05/29  12:39:40  drapeau
 * Changed the name of the "Selection" structure to "MAESelection",
 * to avoid name conflicts with other software packages and toolkits
 * that might also define a "Selection" structure.
 * 
 * Revision 1.16  91/11/25  13:00:57  drapeau
 * Added a new function, DestroyPort().  De-allocates space taken by a
 * Port*.
 * 
 * Revision 1.15  91/09/18  12:38:59  drapeau
 * - Modified the definitions of the messaging functions so that they conform to ANSI-C specs.
 * - Added a definition of the new function DestroyPortArray().
 * - Changed definition of getportfromname_1() function to reflect the new return value (the message
 *   now returns an array of matching Ports rather than just a single Port).
 * - Other minor cosmetic changes to clean up the code.
 * 
 * Revision 1.14  91/09/03  16:54:33  drapeau
 * Modified definition of the "GetPortFromName" message so that it returns
 * a Port* instead of a void*.
 * 
 * Revision 1.13  91/06/19  13:56:45  drapeau
 * Added support for five new messages:
 *  - PauseSelection
 *  - ResumeSelection
 *  - HideApplication
 *  - ShowApplication
 *  - GetAppIcon
 * Also, replaced the "PerformPartialSelection" message with
 * "HaltSelection" message.
 * Added two new fields to the Selection structure:
 *  - offset: number of milliseconds from the start of the selection, used for
 *    telling applications to perform partial selections (the selection is set
 *    with the appropriate offset).
 *  - label:  brief, descriptive text for the current selection, if available.
 * 
 * Added a new data structure, IconData, for the new GetAppIcon message.
 * 
 * Revision 1.12  91/06/17  18:17:11  drapeau
 * Added copyright notice.
 * 
 * Revision 1.11  91/02/28  07:13:12  drapeau
 * No code changes; this version uses a new version numbering scheme and new
 * version of RCS.
 * 
 * Revision 1.1  90/10/24  18:19:04  drapeau
 * Initial revision
 *  */

#ifndef _MAEstroHeader_
#define _MAEstroHeader_

static char maestroRcsid[] = "$Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstro.h,v 1.17 92/05/29 12:39:40 drapeau Exp $";

#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>

#define LabelLength 256

struct Port
{
  char*	hostName;
  char*	appName;
  int	portNumber;
};
typedef struct Port Port;


struct PortArray
{
  Port*	portArray;
  int 	numberOfPorts;
};
typedef struct PortArray PortArray;


struct MAESelection
{
  int 	start;
  int 	end;
  int	duration;
  int 	offset;
  char 	label[LabelLength];
};
typedef struct MAESelection MAESelection;


struct IconData
{
  char*	iconData;
  int	dataLength;
};
typedef struct IconData IconData;


typedef struct _DispatchTable
{
void		(*openDocumentPtr)(char**);
char**		(*getCurrentDocNamePtr)(void*);
MAESelection*	(*getSelectionPtr)(void*);
void		(*setSelectionPtr)(MAESelection*);
void		(*performSelectionPtr)(void*);
void		(*connectWithPortMgrPtr)(Port*);
PortArray*	(*getOpenAppsPtr)(void*);
PortArray*	(*getPortFromNamePtr)(Port*);
void		(*dispatchMessagePtr)(struct svc_req*, SVCXPRT*);
void		(*disconnectFromPortMgrPtr)(Port*);
void		(*pingPtr)(void*);
void		(*haltSelectionPtr)(void*);
void		(*pauseSelectionPtr)(void*);
void		(*resumeSelectionPtr)(void*);
void		(*hideApplicationPtr)(void*);
void		(*showApplicationPtr)(void*);
IconData*	(*getAppIconPtr)(void*);
} DispatchTable;


#define MAEstro ((u_long)99)
#define FirstTestVersion ((u_long)1)
#define OpenDocumentProc ((u_long)1)
#define GetCurrentDocNameProc ((u_long)2)
#define GetSelectionProc ((u_long)3)
#define SetSelectionProc ((u_long)4)
#define PerformSelectionProc ((u_long)5)
#define ConnectWithPortMgrProc ((u_long)6)
#define GetOpenAppsProc ((u_long)7)
#define GetPortFromNameProc ((u_long)8)
#define DisconnectFromPortMgrProc ((u_long)9)
#define PingProc ((u_long)10)
#define HaltSelectionProc ((u_long)11)
#define PauseSelectionProc ((u_long)12)
#define ResumeSelectionProc ((u_long)13)
#define HideApplicationProc ((u_long)14)
#define ShowApplicationProc ((u_long)15)
#define GetAppIconProc ((u_long)16)


#define	PortMgrPortNumber 6600
#define AnyPort 0

bool_t	xdr_Port();
bool_t	xdr_PortArray();
bool_t	xdr_MAESelection();
bool_t	xdr_IconData();
void	DestroyPortArray(PortArray* thePortArray);
void	DestroyPort(Port* thePort);


extern void		bzero(void*, int);
extern void*		opendocument_1(char** argp, CLIENT* clnt);
extern char**		getcurrentdocname_1(void* argp, CLIENT* clnt);
extern MAESelection*	getselection_1(void* argp, CLIENT* clnt);
extern void*		setselection_1(MAESelection* argp, CLIENT* clnt);
extern void*		performselection_1(void* argp, CLIENT* clnt);
extern void*		connectwithportmgr_1(Port* argp, CLIENT* clnt);
extern PortArray*	getopenapps_1(void* argp, CLIENT* clnt);
extern PortArray*	getportfromname_1(Port* argp, CLIENT* clnt);
extern void*		disconnectfromportmgr_1(Port* argp, CLIENT* clnt);
extern void*		ping_1(void* argp, CLIENT* clnt);
extern void*		haltselection_1(void* argp, CLIENT* clnt);
extern void*		pauseselection_1(void* argp, CLIENT* clnt);
extern void*		resumeselection_1(void* argp, CLIENT* clnt);
extern void*		hideapplication_1(void* argp, CLIENT* clnt);
extern void*		showapplication_1(void* argp, CLIENT* clnt);
extern IconData*	getappicon_1(void* argp, CLIENT* clnt);

#endif
