/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_Xrc.c                                                     |
|                                                                              |
|    Contents : Xresource functions                                            |
|                                                                              *
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

/* these should be unique random keys */

#define RESOURCE_CLASS_KEY      982352
#define RESOURCE_INSTANCE_KEY   987243
#define RESOURCE_MODIFIED_KEY   874352
#define RESOURCE_TYPE_KEY       872431
#define DEFAULT_VALUE_KEY       876435

/* types of resources */

#define BOOL_RESOURCE           1
#define INT_RESOURCE            2
#define CHAR_RESOURCE           3
#define STRING_RESOURCE         4

void LoadResources();
void StoreResources();

char        *home;			/* the user's home directory          */
char        fmhome[PATHLEN + FILELEN];	/* the FrameMaker home directory      */
char        *programname;		/* name of this program               */
char        tmpbuf[ 1024 ];		/* temporary string buffer            */
char        MString[PATHLEN];
XrmDatabase user_private_resources;	/* loaded from ~/resourcefile         */
Display     *display;

/******************************************************************************\
*                                                                              *
*    Function : Xrc_init                                                       *
*                                                                              *
* Description : load and merge resource databases                              *
*                                                                              *
\******************************************************************************/

void
Xrc_init(int *argc_ptr, char **argv)
{
    char *apphome;
    char *owh;
    char *xenv;
 
    if (0 == strcmp(FrameVersion, "FrameMaker2.1.1"))
    {
        strcpy(resourcefile, ".MaMA211.rc");
    } else
 
    if (0 == strcmp(FrameVersion, "FrameMaker3.0-X"))
    {
        strcpy(resourcefile, ".MaMA30.rc");
    } else
 
    if (0 == strcmp(FrameVersion, "FrameMaker3.1"))
    {
        strcpy(resourcefile, ".MaMA31.rc");
    } else {
        strcpy(resourcefile, ".MaMA.rc");
    }

    home = strdup(getenv("HOME"));

    sprintf(tmpbuf, "%s/%s", home, resourcefile);

    if (stat(tmpbuf, fileInfo) == 0)
    {
        sprintf(tmpbuf ,"xrdb -merge %s/%s", home, resourcefile);
        system(tmpbuf);
    }

    display = XOpenDisplay(getenv("DISPLAY"));

    /* 
     * inititalize xview defaults since we haven't called xv_init() yet
     */
    defaults_init_db();

    /* 
     * load any OpenWindows app-defaults files that 
     * contain classes in which we are interested 
     */
    if ( owh = getenv( "OPENWINHOME" ) )
    {
        sprintf( tmpbuf, "%s/lib/app-defaults/%s", owh, "MaMA" );
        defaults_load_db( tmpbuf );
    }

    /*
     * load any X11 app-defaults files that contain
     * classes in which we are interested 
     */
    sprintf( tmpbuf, "/usr/lib/X11/app-defaults/%s", "MaMA" );

    /*
     * call xv_init() and parse out the xview args 
     * note that this loads ~/.Xdefaults and the 
     * XA_RESOURCE_MANAGER resources, but it does
     * not load $XENVIRONMENT nor does it accept 
     * any application specific XrmOptionDescRec's. 
     */
    xv_init(XV_INIT_ARGC_PTR_ARGV, argc_ptr, argv,
        XV_USE_LOCALE, TRUE,
        XV_LOCALE_DIR, ".", NULL);
 
    /* 
     * look for our user specific resource file 
     */
    apphome = getenv( "MaMAHOME" );
    if ( !apphome )
    {
        apphome = home;
    }

    if ( apphome )
    {
        sprintf( tmpbuf, "%s/%s", apphome, resourcefile );
        defaults_load_db( tmpbuf );
    }

    /* 
     * go ahead and load $XENVIRONMENT
     */
    if ( xenv = getenv( "XENVIRONMENT" ) )
    {
        defaults_load_db( xenv );
    }
}

/******************************************************************************\
*                                                                              *
*    Function : Apply_Pref                                                     *
*                                                                              *
* Description : Apply the set preferences                                      *
*                                                                              *
\******************************************************************************/

void
Apply_Pref()
{
    char *klasse;
    int  intval;
    char *strval;
    char automntstr[PATHLEN];
    int  type;
    int  row;
    AUTOMNTLIST *AutoMntListPtr;
 
    LoadResources();

    /*
     * FrameMaker version command
     */
    klasse = (char *) xv_get(MaMA_Pref_Panel->Frame_path_tf, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );
    strval = (char *)xv_get(MaMA_Pref_Panel->Frame_path_tf, PANEL_VALUE );
    strcpy(FramePath, strval);

    defaults_set_string( klasse, strval );
    XrmPutStringResource( &user_private_resources, klasse, strval );
 
    /*
     * Open FrameMaker documents for each Action?
     */
    klasse = (char *) xv_get(MaMA_Pref_Panel->Open_FM_Setting, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );
    intval = xv_get(MaMA_Pref_Panel->Open_FM_Setting, PANEL_VALUE );
    OpenFM4EachAction = intval;

    defaults_set_boolean( klasse, (Bool) intval );
    XrmPutStringResource( &user_private_resources, klasse, 
        intval ? "TRUE" : "FALSE" );

    /*
     * Auto mount directories
     */
    klasse = (char *) xv_get(MaMA_Pref_Panel->AutoMnt_List, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );

    AutoMntListPtr = AutoMntList;
    if (AutoMntListPtr == NIL(AUTOMNTLIST *))
    {
        XrmPutStringResource( &user_private_resources, klasse, "");
    } else {
        /*
         * concatenate auto mount directories into one string
         */
        strcpy(automntstr, AutoMntListPtr->Dir);
        while (AutoMntListPtr->next != NIL(AUTOMNTLIST *))
        {
            AutoMntListPtr = AutoMntListPtr->next;
            strcat(automntstr, ":");
            strcat(automntstr, AutoMntListPtr->Dir);
        }

        defaults_set_string( klasse, automntstr);
        XrmPutStringResource( &user_private_resources, klasse, automntstr);
    }

    StoreResources();
}

/******************************************************************************\
*                                                                              *
*    Function : Reset_Pref                                                     *
*                                                                              *
* Description : Reset the preferences                                          *
*                                                                              *
\******************************************************************************/

void
Reset_Pref()
{
    char *instance;
    char *klasse;
    int  type;
    int  defint;
    char *defstring;
    char strval[PATHLEN];
    int  MInt;
 
    /*
     * FrameMaker version path
     */
    instance = (char *) xv_get(MaMA_Pref_Panel->Frame_path_tf, 
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY );
    klasse = (char *) xv_get(MaMA_Pref_Panel->Frame_path_tf, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );
    defstring = (char *) xv_get(MaMA_Pref_Panel->Frame_path_tf, 
        XV_KEY_DATA, DEFAULT_VALUE_KEY );

    strcpy(MString, (char *)defaults_get_string( instance, klasse, defstring));
    xv_set(MaMA_Pref_Panel->Frame_path_tf, PANEL_VALUE, MString, NULL);
    strcpy(FramePath, MString);

    /*
     * Open FrameMaker documents for each Action?
     */
    instance = (char *) xv_get(MaMA_Pref_Panel->Open_FM_Setting, 
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY );
    klasse = (char *) xv_get(MaMA_Pref_Panel->Open_FM_Setting, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );
    defint = (int) xv_get(MaMA_Pref_Panel->Open_FM_Setting, 
        XV_KEY_DATA, DEFAULT_VALUE_KEY );
    MInt = defaults_get_boolean( instance, klasse, defint);

    xv_set(MaMA_Pref_Panel->Open_FM_Setting, PANEL_VALUE, MInt, NULL);
    OpenFM4EachAction = MInt;

    /*
     * Auto mount directories
     */
    instance = (char *) xv_get(MaMA_Pref_Panel->AutoMnt_List, 
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY );
    klasse = (char *) xv_get(MaMA_Pref_Panel->AutoMnt_List, 
        XV_KEY_DATA, RESOURCE_CLASS_KEY );
    defstring = (char *) xv_get(MaMA_Pref_Panel->AutoMnt_List, 
        XV_KEY_DATA, DEFAULT_VALUE_KEY );

    strcpy(MString, (char *)defaults_get_string( instance, klasse, defstring ));

    FillAutoMntList(MString);
}

void
FillAutoMntList(char *MString)
{
    char *Result;
    AUTOMNTLIST *AutoMntListPtr;
    AUTOMNTLIST *NewAutoMnt;

    /*
     * free old Auto mount list
     */
    while (AutoMntList != NIL(AUTOMNTLIST *))
    {
        AUTOMNTLIST *Tmp;
        Tmp = AutoMntList;
        AutoMntList = AutoMntList->next;
        free(Tmp);
    }
    AutoMntList = NIL(AUTOMNTLIST *);

    /*
     * split string
     */
    Result = (char *)strtok(MString, ":");

    if (Result != (char *)0)
    {
        NewAutoMnt = (AUTOMNTLIST *)malloc((unsigned)sizeof(AUTOMNTLIST));
        NewAutoMnt->next = NIL(AUTOMNTLIST *);
        strcpy(NewAutoMnt->Dir, Result);

        AutoMntList = NewAutoMnt;
        AutoMntListPtr = AutoMntList;

        while((Result = (char *)strtok(NULL, ":")) != (char *)0)
        {
            NewAutoMnt = (AUTOMNTLIST *)malloc((unsigned)sizeof(AUTOMNTLIST));
            NewAutoMnt->next = NIL(AUTOMNTLIST *);
            strcpy(NewAutoMnt->Dir, Result);

            AutoMntListPtr->next = NewAutoMnt;
            AutoMntListPtr = AutoMntListPtr->next;
        }
    }
}

/******************************************************************************\
*                                                                              *
*    Function : LoadResources                                                  *
*                                                                              *
* Description :                                                                *
*                                                                              *
\******************************************************************************/

void LoadResources()
{
    if ( user_private_resources )
    {
        XrmDestroyDatabase( user_private_resources );
    }

    if ( home )
    {
        sprintf( tmpbuf, "%s/%s", home, resourcefile );
        user_private_resources = XrmGetFileDatabase( tmpbuf );
    } else {
        user_private_resources = (XrmDatabase) 0;
    }
}

/******************************************************************************\
*                                                                              *
*    Function : StoreResources                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
\******************************************************************************/

void StoreResources()
{
    if ( user_private_resources )
    {
        if ( home )
        {
            sprintf( tmpbuf, "%s/%s", home, resourcefile );
            XrmPutFileDatabase( user_private_resources, tmpbuf );
        } else {
            fprintf( stderr, "%s: no home directory!\n", programname );
        }
        XrmDestroyDatabase( user_private_resources );
        user_private_resources = (XrmDatabase) 0;
    }
}

/******************************************************************************\
*                                                                              *
*    Function : Add_Resource_Data                                              *
*                                                                              *
* Description :                                                                *
*                                                                              *
\******************************************************************************/

void
Add_Resource_Data()
{
    char *strval;
    int  intval;

    strcpy(fmhome, (char *)getenv("FMHOME"));
    if (fmhome == NULL)
    {
        strcpy(fmhome, strdup(""));
    } else {
        strcat(fmhome, "/bin/imaker");
    }

    xv_set(MaMA_Pref_Panel->Frame_path_tf, 
        XV_KEY_DATA, RESOURCE_TYPE_KEY, STRING_RESOURCE,
        XV_KEY_DATA, RESOURCE_CLASS_KEY, "MaMA.FramePath",
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY, "mama.FramePath",
        XV_KEY_DATA, DEFAULT_VALUE_KEY, fmhome,
        NULL);

    xv_set(MaMA_Pref_Panel->Open_FM_Setting, 
        XV_KEY_DATA, RESOURCE_TYPE_KEY, BOOL_RESOURCE,
        XV_KEY_DATA, RESOURCE_CLASS_KEY, "MaMA.OpenSetting",
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY, "mama.OpenSetting",
        XV_KEY_DATA, DEFAULT_VALUE_KEY, FALSE,
        NULL);

    xv_set(MaMA_Pref_Panel->AutoMnt_List, 
        XV_KEY_DATA, RESOURCE_TYPE_KEY, STRING_RESOURCE,
        XV_KEY_DATA, RESOURCE_CLASS_KEY, "MaMA.AutoMntDirectories",
        XV_KEY_DATA, RESOURCE_INSTANCE_KEY, "mama.AutoMntDirectories",
        XV_KEY_DATA, DEFAULT_VALUE_KEY, "/tmp_mnt",
        NULL);

    Reset_Pref();

    /*
     * Get values from Xresource file
     */
    sprintf(tmpbuf, "%s/%s", home, resourcefile);

    if ((display != NIL(Display *)) && (stat(tmpbuf, fileInfo) == 0))
    {
        strcpy(MString, (char *)XGetDefault(display, "MaMA", "FramePath"));
        xv_set(MaMA_Pref_Panel->Frame_path_tf, PANEL_VALUE, MString, NULL);

        intval = (int)XGetDefault(display, "MaMA", "OpenSetting");
        xv_set(MaMA_Pref_Panel->Open_FM_Setting, PANEL_VALUE, intval, NULL);

        strcpy(MString, (char *)XGetDefault(display, "MaMA",
            "AutoMntDirectories"));
        FillAutoMntList(MString);
    }
}
