#ifndef _xvHeader_
#define _xvHeader_
/*
 *  xv.h  -  header file for xv, but you probably guessed as much
 */

/*
 * Copyright 1989, 1990 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any express or implied warranty.
 */
/* $Header $ */
/* $Log $ */
#define REVDATE   "Rev: 11/29/90  (Patchlevel 3)"

#ifdef SVR4             /* SysV release 4 uses dirent */
#ifndef sgi             /* but Silicon Graphics doesn't */
#define DIRENT
#endif
#endif


/* include files */
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
extern int   errno;             /* this SHOULD be in errno.h */
extern char *sys_errlist[];     /* this SHOULD be in errno.h */

#ifndef __convexc__             /* Convex doesn't have <memory.h> */
#include <memory.h>             /* for 'memset()' prototype */
#endif

/* neither IBM AOS 4.3, Convex, nor BSD 4.3 on VAX have <malloc.h> */
#if !defined(ibm032) && !defined(__convexc__) && \
    !(defined(vax) && !defined(ultrix))
#if defined(hp300) || defined(hp800)
#include <sys/malloc.h>                /* it's in 'sys' on HPs*/
#else
#include <malloc.h>
#endif
#endif


#if defined(NEED_MEMROUTINES)
#define memcpy(d,s,l) bcopy(s,d,l)
#endif


#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>


#if defined(NEEDSTIME) || defined(NEEDSDIR)
#include <sys/types.h>    /* only include <sys/types.h> once */
#endif

#ifdef NEEDSTIME
#ifndef sgi              /* silicon graphics doesn't have timeb.h */
#include <sys/timeb.h>
#endif
#include <signal.h>
#if defined(sco) && !defined(NOTIMER)
#include <sys/itimer.h>
#endif
#ifndef  sigmask
#define  sigmask(m)      (1 << ((m)-1))
#endif
#endif

#ifdef NEEDSDIR
#ifdef sco
#include <sys/ndir.h>
#define lstat stat
#else
#ifndef ATT
#include <sys/dir.h>
#endif  /* ATT */
#endif  /* sco */
#include <sys/param.h>
#include <sys/stat.h>
#ifdef DIRENT
#include <dirent.h>
#endif
#endif

#ifdef NEEDSVARARGS
#include <varargs.h>
#endif

#ifdef i386
#define MAXPATHLEN    500
#endif

#define F_GREYSCALE 1
#define MAXNAMES 1024   /* max # of files (more than this?  Get REAL!) */

/* MACROS */
/* RANGE forces a to be in the range b..c (inclusive) */
#define RANGE(a,b,c) { if (a<b) a=b;  if (a>c) a=c; }

/* MONO returns total intensity of r,g,b components */
#define MONO(rd,gn,bl) (((rd)*11 + (gn)*16 + (bl)*5) >> 5)  /*.33R+ .5G+ .17B*/

/* types of 24-to-8 conversion */
#define CONV24_FAST 0
#define CONV24_SLOW 1
#define CONV24_BEST 2

/* X stuff */
Display       *theDisp;
int           theScreen;
unsigned int  ncells, dispWIDE, dispHIGH, dispDEEP;
Colormap      theCmap, LocalCmap;
Window        rootW, mainW;
GC            theGC;
unsigned long black, white, fg, bg, infofg, infobg;
Visual        *theVisual;

typedef unsigned char byte;

/* global vars used by LOAD routines */
byte          *pic;                   /* ptr to loaded picture */
unsigned int   pWIDE,pHIGH;           /* size of 'pic' */
byte           r[256],g[256],b[256];  /* colormap */
char          *cmd;                   /* program name for printf's */
int            DEBUG;                 /* print debugging info */
int            mono;                  /* true if displaying grayscale */


/* more global variables, used by xv and xvmisc */
byte          *cpic;         /* cropped version of pic */
unsigned int  cWIDE, cHIGH,  /* size of cropped region */
                    cXOFF, cYOFF;  /* offset of region from 0,0 of pic */

byte          *epic;         /* expanded version of cpic */
                                   /* points to pic when at 1:1 expansion */
                                   /* this is converted to 'theImage' */
unsigned int  eWIDE, eHIGH;  /* size of epic */
unsigned int  normFact;      /* factor to shrink picture by for 'norm' */

byte           rorg[256],gorg[256],borg[256];  /* ORIGINAL colormap */
byte           gamcr[256];   /* gamma correction curve */
byte           fsgamcr[256]; /* gamma correction curve (for FS dither) */
char           *namelist[MAXNAMES];  /* list of file names from argv */
int            numnames, curname;
char           formatStr[80];

int           verbose;
unsigned long freecols[256]; /* list of pixel values to free */
int           nfcols;        /* number of colors to free */
unsigned long cols[256];     /* maps pic pixel values to X pixel vals */
int           fc2pcol[256];  /* maps freecols into pic pixel values */
int           numcols;       /* # of desired colors in picture */
int           ncols;         /* max # of (different) colors to alloc */

char          str[128];      /* dummy string used for error messages */

int           expand,        /* expansion amount */
                    bwidth,        /* border width of created windows */
                    noglob,        /* force to only use colors it alloced */
                    revvideo,      /* reverse video */
                    perfect,       /* perfect color.  install own colormap */
                    fixedaspect,   /* fixed aspect ratio */
                    conv24,        /* use slow 24to8 algorithm */
                    ninstall,      /* true if using icccm-complaint WM
				      (a WM that will does install CMaps */
                    useroot,       /* true if we should draw in rootW */
                    noqcheck,      /* true if we should NOT do QuickCheck */
                    rwcolor,       /* true if we should use R/W color cells */
                    rwthistime,    /* true if we DID use R/W color cells */
                    brokeFreeCols, /* true if server has broken XFreeColors */
                    fish,          /* turn on annoying fish */
                    fishrunning;   /* true if fish are in operation */

float         defaspect,     /* default aspect ratio to use */
                    normaspect;    /* normal aspect ratio of this picture */

int           crx1, cry1,    /* dimensions of cropping rectangle */
                    crx2, cry2;

/* function declarations for externally-callable functions */

#ifdef __STDC__ 

/*************************** XVMISC.C ***************************/
Window CreateWindow(char *, char *, unsigned int, unsigned int, 
		    unsigned long, unsigned long);
void SortColormap(void);
void AllocColors(void);
void DoMonoAndRV(void);
void FatalError(char *);

/*************************** XV24TO8.C **************************/
int  Conv24to8(byte *, int, int, int);
void InitFSDTables(void);

/**************************** XVGIF.C ***************************/
int LoadGIF(char *, int);

/**************************** XVTIFF.C ***************************/
int LoadTIFF(char *, int);
/* int WriteTIFF(FILE *, byte *, int, int, char *); */

/**************************** XVJPEG.C ***************************/
int LoadJFIF(char *, int);

#else     /* using non-ANSI cc.  Function defs, but no params */

/*************************** XVMISC.C ***************************/
Window CreateWindow();
XImage*		Resize(byte* origData, int origWidth, int origHeight,
		       int newWidth, int newHeight);
void SortColormap();
void AllocColors();
void DoMonoAndRV();
void FatalError();


/*************************** XV24TO8.C **************************/
int  Conv24to8();
void InitFSDTables();

/**************************** XVGIF.C ***************************/
int LoadGIF();


/**************************** XVTIFF.C ***************************/
int LoadTIFF();
/*  WriteTIFF(); */

/**************************** XVJPEG.C ***************************/
int LoadJFIF();

#endif
#endif
