/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/clipboard.c,v 1.1 92/10/29 13:53:25 drapeau Exp $ */
/* $Log:	clipboard.c,v $
 * Revision 1.1  92/10/29  13:53:25  drapeau
 * Initial revision
 *  */
static char dtClipboard[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/clipboard.c,v 1.1 92/10/29 13:53:25 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"


/*
 * Menu handler for `slidesMenu (Copy Slide)'.
 */
Menu_item
  CopySlide(Menu_item item, Menu_generate op)
{
  int i;
  
  if (op == MENU_NOTIFY)
    {
      theCmap = slidesCmap;
      theDisp = display;
      for (i=0; i<numClipboardImages; i++)			    /* Erase all images currently in the clipboard */
	FreeImage(clipboardImage[i]); 
      numClipboardImages = 0;
      for (i=0; i < numSlidesImages; i++)
	if (dtImage[i]->slide == selectedSlide)
	  {
	    clipboardImage[numClipboardImages] = (IMAGE)MyMalloc(sizeof(struct ImageStruct));
	    NullFields(clipboardImage[numClipboardImages]);
	    CopyImage(dtImage[i], clipboardImage[numClipboardImages]);
	    numClipboardImages++;
	  }   
    } 
  return item;
}								    /* end function CopySlide */


/*
 * Menu handler for `slidesMenu (Cut Slide)'.
 */
Menu_item
  CutSlide(Menu_item item, Menu_generate op)
{
  int i;
  if (op == MENU_NOTIFY)
    {
      CopySlide(baseWindow->baseWindow, MENU_NOTIFY);
      ClearSlide(baseWindow->baseWindow, MENU_NOTIFY);
      for (i=0; i<numSlidesImages; i++)
	if (dtImage[i]->slide > selectedSlide)
	  dtImage[i]->slide--;
      changes = True;
      SlidesRepaint(NULL, NULL, NULL, NULL);
      SetTotalNumberOfSlides();
    } 
  return item;
}

/*
 * Menu handler for `slidesMenu (Insert Clipboard Slide)'.
 */
Menu_item
  InsertClipboardSlide(Menu_item item, Menu_generate op)
{
  int i;
  if (op == MENU_NOTIFY)
    {
      InsertNewSlide(baseWindow->baseWindow, MENU_NOTIFY);
      for (i=0; i<numClipboardImages; i++)
	{
	  if (dtImage[numSlidesImages] == (IMAGE)NULL)
	  {
	    dtImage[numSlidesImages] = (IMAGE)MyMalloc(sizeof(struct ImageStruct));
	    NullFields(dtImage[numSlidesImages]);
	  }
	  CopyImage(clipboardImage[i], dtImage[numSlidesImages]);
	  dtImage[numSlidesImages]->slide = selectedSlide;
	  numSlidesImages++;
	}
      changes = True;
      SlidesRepaint(NULL, NULL, NULL, NULL);
      SetTotalNumberOfSlides();
    } 
  return item;
}

/*
 * Menu handler for `slidesMenu (Clear Slide)'.
 */
Menu_item
  ClearSlide(Menu_item	item, Menu_generate op)
{
  int i, j = 0;
  if (op == MENU_NOTIFY)
    {
      theCmap = slidesCmap;
      theDisp = display;
      for (i=0; i<numSlidesImages; i++)
	if (dtImage[i]->slide != selectedSlide)
	  dtImage[j++] = dtImage[i]; 
	else
	  FreeImage(dtImage[i]);
      numSlidesImages = j;
      if ((int)item != (int)baseWindow->baseWindow)
	SlidesRepaint(NULL, NULL, NULL, NULL);
      changes = True;
      SetTotalNumberOfSlides();
    } 
  return item;
}
