#ifndef _DisplayToolHeader_
#define _DisplayToolHeader_
/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <ctype.h>
#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/cursor.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <xview/frame.h>
#include <xview/scrollbar.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/svrimage.h>
#include <xview/icon.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <gdd.h>
#include <gcm.h>
#include "DisplayTool_ui.h"
#include "xvimage.h"
#include <Sender.h>
#include <Receiver.h>
#include <getopt.h>
#include <Browse.h>


/*
 *   program constants
 */ 
#define IconX 64
#define IconY 64
#define Depth 8
#define NumColors 256
#define MaxNumImages 512
#define MaxNumSlides 36
#define FullWidth 1122
#define FullHeight 852
#define SmallWidth 192
#define SmallHeight 154
#define Small 0
#define Large 1
#define CancelQuit 0
#define MaxLength MAXPATHLEN
#define AllSizes -1
#define NotInBuffer -1
#define SlidesPerRow 3
#undef  None
#define None -1
#define Red 0
#define Green 1
#define Blue 2
#define BorderOffset 208
#define Correction 3
#define Cancel 0
#define Confirm 1

/*
 *  program type structures
 */
struct ImageStruct 
{
  int		origWidth, origHeight;
  int		largeWidth, largeHeight;
  int		galleryWidth, galleryHeight;
  char*		filename;
  char*		format;
  byte*		imageData;
  XImage*	galleryImage;
  XImage*	slideImage;
  XImage*	largeImage;
  int		numcols;
  int		nfcols;
  unsigned long	cols[NumColors];
  unsigned long freecols[NumColors];
  int		slide;
  XPoint	corner;
};

struct SlideStruct
{
  char*	duration;
  char*	label;
  int	numberOfImages;
  int	imageIds[MaxNumImages/2];
};

typedef struct SlideStruct *SCR;
typedef struct ImageStruct *IMAGE;

/*
 * function declarations - prototypes
 */
void  LoadImage(),
  CanvasEventProc(),
  ShowPopup(),
  HidePopup(),
  HighlightImage(),
  ResizeImage(),
  RedrawRectangles(),
  SlidesRepaint(),
  GalleryRepaint(),
  PopupRepaint(),
  WriteSlideInfoToPanel(int i),
  Reverse(char *string),
  WriteSequenceToFile(),
  GetOffsets(),
  CropIfNecessary(),
  FreeImage(),
  CopyImage(),
  SetTotalNumberOfSlides(),
  CheckGeometry(),
  FreeColors(),
  CheckOptions(),
  DisplayMultipleWindows(),
  PrepareMultipleWindowsForDisplay(),
  SetCurrentSlide(),
  PrintCmap(),
  NullFields(),
  CreateCopyOfImage(),
  SlideEventUp(),
  SlideEventDown(),
  SlideEventResize(),
  PlaceImage(),
  EraseOldImage(),
  DrawNewImage(),
  NoImageSelected(),
  ClearList(),
  KillPopups();
void	LoadGalleryImage(char *file);
void	HighlightGalleryImage(int imageNum, int oldImageNum);
void	DisplayImages(int slideNum);
void	KillOldPopupsOnly(void);
char*	MyMalloc(unsigned int size);
void	PrintDTDiagnostics(char* theString);
Menu_item	ClearAll(Menu_item item, Menu_generate op);
void	ShowFullSize(Panel_item item, int value, Event *event);
void	FreeMemoryForSlide(int slideNum);
void	PaintSlideImage(IMAGE theImage, int srcX, int srcY, int destX, int destY);
void	GetEffectiveDimensions(IMAGE tempImage, int *width, int *height);
void	InitSlide(SCR theSlide);
void	PaintSlide(int slideNum);
void	PaintGalleryImage(int imageNum);
void	BusyApp(void);
void	NormalApp(void);



int   WhichImage(),
  WhichSlide(),
  CheckChanges(),
  OpenHandler(),
  SaveHandler(),         
  OpenEditFile(),
  GetMaxSlide(),
  AlreadyInGalleryBuffer(),
  NotifyChoice(),
  AlreadyInSlidesBuffer();

char *getwd();
char *realpath();

IMAGE		CreateImage(char* file);
IMAGE		ReCreateImage(IMAGE image);
IMAGE		xvimage_main(char* file);
XImage*		Resize(byte*	origData,
		       int	origWidth, int origHeight,
		       int	newWidth, int newHeight);

Frame		PopupCreate(Frame owner, int width, int height);
Canvas		CanvasCreate(Frame owner, int width, int height);
Menu_item	ClearSlide(Menu_item, Menu_generate);
Menu_item	InsertNewSlide(Menu_item, Menu_generate);
Notify_value	QuitNotify();
Notify_value	IncrementCounter();
Notify_value	GalleryEventProc(Xv_window win,Event* event,Notify_arg arg, Notify_event_type type);
Notify_value	SlidesEventProc(Xv_window win,Event* event,Notify_arg arg, Notify_event_type type);


/*
 *  Networking functions and variables
 */
void OpenDoc(),
  SetSelection(),
  PerformSelection(),
  HaltSelection(),
  PauseSelection(),
  ResumeSelection(),
  HideApplication(),
  ShowApplication();

char **GetDoc();
MAESelection   *GetSelection();
IconData       *GetAppIcon();


/*
 *  Networking functions and variables
 */
void OpenDoc(),
  SetSelection(),
  PerformSelection(),
  HaltSelection(),
  PauseSelection(),
  ResumeSelection(),
  HideApplication(),
  ShowApplication();

char **GetDoc();
MAESelection   *GetSelection();
IconData       *GetAppIcon();

#endif  _DisplayToolHeader_
