/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/pause.c,v 1.0 92/01/07 14:23:09 drapeau Exp Locker: derek $ */
/* $Log:	pause.c,v $
 * Revision 1.0  92/01/07  14:23:09  drapeau
 * Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.16  91/09/18  22:47:33  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.15  91/08/16  18:10:46  derek
 * 
 * The following things are done:
 * 1.	I have fixed an openpanel bug in my code in which I 
 * 	made the app return the wrong values to OpenHandler and
 * 	the SaveHandler.
 * 2.	The flashing color of the play button has been changed from
 * 	Red to Green.
 * 3.	Fixed a quantization bug: Buffer.play.end, when converted
 * 	from endingTimeInSec, should not exceed Buffer_hdr_data_size - 1.
 * 
 * Revision 0.14  91/08/13  20:38:35  derek
 * The buttons (play, pause, record) will now flash after they are pressed.
 * This only applies to times when audio files (not edit-lists) are 
 * played.
 * 
 * Revision 0.13  91/08/07  16:24:34  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.12  91/06/26  15:55:20  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.11  91/06/05  15:00:01  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:49:16  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/pause.c,v 1.0 92/01/07 14:23:09 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

void
  Pause()
{
  extern   dtr_mainWindow_objects               *dtr_mainWindow;

  EVENT("Pause");
  if (!ActiveFlag)
    return;
  if (ActiveFlag & PLAY)
  {
    if (Buffer.paused)
    {
      (void) audio_resume_play(Audioctl_fd);
      xv_set(dtr_mainWindow->pauseButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
    }
    else
    {
      (void) audio_pause_play(Audioctl_fd);
      xv_set(dtr_mainWindow->pauseButton, PANEL_ITEM_COLOR, GreenColorIndex, NULL);
      xv_set(dtr_mainWindow->playButton, PANEL_ITEM_COLOR, GreenColorIndex, NULL);
    }
  }
  if (ActiveFlag & RECORD)
  {
    if (Buffer.paused)
    {
      (void) audio_resume_record(Audioctl_fd);
      xv_set(dtr_mainWindow->pauseButton, PANEL_ITEM_COLOR, BlackColorIndex, NULL);
    }
    else
    {
      (void) audio_pause_record(Audioctl_fd);
      xv_set(dtr_mainWindow->pauseButton, PANEL_ITEM_COLOR, RedColorIndex, NULL);
      xv_set(dtr_mainWindow->recordButton, PANEL_ITEM_COLOR, RedColorIndex, NULL);
    }
  }
}	

