/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/dtrutils.c,v 1.10 92/01/09 12:41:47 drapeau Exp Locker: derek $ */
/* $Log:	dtrutils.c,v $
 * Revision 1.10  92/01/09  12:41:47  drapeau
 * Slight modifications to the code to make it ANSI-compliant.
 * 
 * Revision 1.0  92/01/06  17:49:23  drapeau
 * Deleted AlertStatus(), since it is no longer needed.
 * Added functions UpdateHeader() and UpdateEditListHeader(), functions that
 * are responsible for displaying the currently opened sound file or
 * DTR edit list.
 * Also, Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.18  91/09/30  16:13:10  derek
 * DTR will now disconnect from the Port Manager when it quits.  Also,
 * a number of printf statements are removed.
 * 
 * Revision 0.17  91/09/18  22:47:22  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.16  91/08/21  11:34:14  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.15  91/08/07  16:24:09  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.14  91/07/31  14:50:58  derek
 * I have changed the user interface so that text fields like size and
 * duration will be displayed in normal (not bold) format.   I also fixed
 * a network bug.  In addition, I have added a routine to check how
 * much disk space is left in /usr/tmp.
 * 
 * Revision 0.13  91/06/26  15:56:17  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.12  91/06/25  11:39:43  derek
 * I have added the new protocol items.
 * 
 * Revision 0.11  91/06/05  14:59:50  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:47:48  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/dtrutils.c,v 1.10 92/01/09 12:41:47 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

extern  dtr_mainWindow_objects *dtr_mainWindow;


/*
 * Alert:  takes an object and a message and calls xv_set
 *         to set the corresponding text field.
 */
void
  Alert(object, message)
Xv_object object;
char      *message;
{
  xv_set(object, PANEL_LABEL_STRING, message, NULL);
}


/*
 * Give null messages to all the message fields: size, duration, 
 * editing status.
 */
void
  ClearMessageDisplay()
{
  sprintf(msg, "");
  Alert(dtr_mainWindow->sizeMessage, msg);
  Alert(dtr_mainWindow->selectionSizeMessage, msg);
  Alert(dtr_mainWindow->durationMessage, msg);
  Alert(dtr_mainWindow->selectionDurationMessage, msg);
}


/*
 *  Check for Null filename.
 */
BOOL
  NullFileName(name)
char *name;
{
  return(strcmp(name, "\0") == 0
	 || strcmp(name, "") == 0);
}


void
  AlertByNoticePrompt(control, message)
Xv_Window	control;
char		*message;
{
  notice_prompt(control, NULL,
		NOTICE_MESSAGE_STRINGS, message, NULL,
		NOTICE_BUTTON, "OK", 'O',
		NULL);
}


Notify_value
  DestroyMainWindow(client, status)
Notify_client client;
Destroy_status status;
{
  if (BufferSaved == FALSE)
  {
    int    reply;
      
    reply = notice_prompt(dtr_mainWindow->menuControlPanel, NULL,
			  NOTICE_MESSAGE_STRINGS,
			  "Buffer not saved yet.",
			  "Quit Anyway?",
			  NULL,
			  NOTICE_BUTTON, "Yes", 'Y',
			  NOTICE_BUTTON, "Cancel", 'C',
			  NULL);
    if (reply == 'C')
      return NOTIFY_DONE;
  }

  AudioFlushClose();
  RemoveSoundFileInTmp();
  SenderDisconnectFromPortMgr(sender, &(receiver->receivePort));
  exit(0);
}


void UpdateHeader(int modified)
{
  char					label[100];
  
  if (modified == TRUE)
  {
    BufferSaved == FALSE;
    sprintf(label, "Digital Tape Recorder : \"%s\" (modified)",
	    currentSoundFile);
  }
  
  else
  {
    BufferSaved == TRUE;
    sprintf(label, "Digital Tape Recorder : \"%s\"",
	    currentSoundFile);
  }
  xv_set(dtr_mainWindow->mainWindow, XV_LABEL, label, NULL);
  return;
}								    /* end function UpdateHeader */


void UpdateEditListHeader(int modified)
{
  extern dtr_editListPanelPopUp_objects*	dtr_editListPanelPopUp;
  char						label[100];
  
  if (modified == TRUE)
    sprintf(label, "DTR Edit List : \"%s\" (modified)",
	    absoluteEditListName);
  else
    sprintf(label, "DTR Edit List : \"%s\"",
	    absoluteEditListName);
  xv_set(dtr_editListPanelPopUp->editListPanelPopUp, XV_LABEL, label, NULL);
  return;
}								    /* end function UpdateHeader */
